/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.cvpl.service.impl;

import egovframework.rte.cvpl.service.CvplSearchVO;
import egovframework.rte.cvpl.service.CvplUserVO;
import egovframework.rte.cvpl.service.EgovCvplUserService;
import egovframework.rte.cvpl.service.impl.CvplUserDAO;
import egovframework.rte.fdl.cmmn.AbstractServiceImpl;
import egovframework.rte.fdl.crypto.EgovEDcryptionService;
import egovframework.rte.fdl.string.EgovStringUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="cvplUserService")
public class EgovCvplUserServiceImpl
extends AbstractServiceImpl
implements EgovCvplUserService {
    @Resource(name="cvplUserDAO")
    private CvplUserDAO cvplUserDAO;
    @Resource(name="cryptolerTxt")
    private EgovEDcryptionService cryptoTxt;
    @Resource(name="cryptolerPwd")
    private EgovEDcryptionService cryptoPwd;

    public String insertCvplUser(CvplUserVO vo) throws Exception {
        this.log.debug((Object)vo.toString());
        String strPwd = vo.getPassword();
        if (strPwd == null || strPwd.length() == 0) {
            strPwd = "1";
        } else {
            String strPwdEncryt;
            this.cryptoPwd.setPlainDigest(true);
            this.cryptoPwd.setConfig(-1, strPwd);
            this.cryptoPwd.setAlgorithm("MD5");
            byte[] ret_Pwdencryt = this.cryptoPwd.encrypt();
            strPwd = strPwdEncryt = new String(ret_Pwdencryt);
        }
        vo.setPassword(strPwd);
        String strIhidnum = vo.getIhidnum();
        if (strIhidnum == null || strIhidnum.length() == 0) {
            strIhidnum = "";
        } else {
            String strEncryt;
            this.cryptoTxt.setComformStr("Egov");
            this.cryptoTxt.setConfig(-1, strIhidnum);
            byte[] ret_encryt = this.cryptoTxt.encrypt();
            strIhidnum = strEncryt = new String(ret_encryt);
        }
        vo.setIhidnum(strIhidnum);
        this.cvplUserDAO.insertCvplUser(vo);
        this.cvplUserDAO.insertCvplUserAuth(vo);
        return vo.getUserId();
    }

    public void updateCvplUser(CvplUserVO vo) throws Exception {
        String strIhidnum = vo.getIhidnum();
        if (strIhidnum == null || strIhidnum.length() == 0) {
            strIhidnum = "";
        } else {
            String strEncryt;
            this.cryptoTxt.setComformStr("Egov");
            this.cryptoTxt.setConfig(-1, strIhidnum);
            byte[] ret_encryt = this.cryptoTxt.encrypt();
            strIhidnum = strEncryt = new String(ret_encryt);
        }
        vo.setIhidnum(strIhidnum);
        this.cvplUserDAO.updateCvplUser(vo);
    }

    public void deleteCvplUser(CvplUserVO vo) throws Exception {
        this.cvplUserDAO.deleteCvplUserAuth(vo);
        this.cvplUserDAO.deleteCvplUser(vo);
    }

    public CvplUserVO selectCvplUser(CvplUserVO vo) throws Exception {
        CvplUserVO resultVO = this.cvplUserDAO.selectCvplUser(vo);
        String strIhidnum1 = "";
        String strIhidnum2 = "";
        if (resultVO == null) {
            throw this.processException("info.nodata.msg");
        }
        if (resultVO.getIhidnum() == null || resultVO.getIhidnum().length() == 0) {
            strIhidnum1 = "";
            strIhidnum2 = "";
        } else {
            this.cryptoTxt.getComformStr("Egov");
            this.cryptoTxt.setConfig(-1, resultVO.getIhidnum());
            byte[] ret_decrypt = this.cryptoTxt.decrypt();
            String strDecrypt = new String(ret_decrypt);
            if (13 == strDecrypt.length()) {
                strIhidnum1 = EgovStringUtil.toSubString((String)strDecrypt, (int)0, (int)6);
                strIhidnum2 = EgovStringUtil.toSubString((String)strDecrypt, (int)6);
            } else {
                strIhidnum1 = strDecrypt;
            }
        }
        resultVO.setIhidnum1(strIhidnum1);
        resultVO.setIhidnum2(strIhidnum2);
        return resultVO;
    }

    public List selectCvplUserList(CvplSearchVO searchVO) throws Exception {
        return this.cvplUserDAO.selectCvplUserList(searchVO);
    }

    public int selectCvplUserListTotCnt(CvplSearchVO searchVO) {
        return this.cvplUserDAO.selectCvplUserListTotCnt(searchVO);
    }

    public boolean checkCvplUserIdDplc(CvplUserVO cvplUserVO) throws Exception {
        int count = 0;
        count = this.cvplUserDAO.checkCvplUserIdDplc(cvplUserVO);
        return count != 0;
    }

    public List excelDownCvplUserList(CvplSearchVO searchVO) throws Exception {
        return this.cvplUserDAO.excelDownCvplUserList(searchVO);
    }
}

