/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice;

import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationMessageHeader;
import egovframework.rte.itl.integration.metadata.IntegrationDefinition;
import egovframework.rte.itl.integration.metadata.OrganizationDefinition;
import egovframework.rte.itl.integration.metadata.ServiceDefinition;
import egovframework.rte.itl.integration.metadata.SystemDefinition;
import egovframework.rte.itl.integration.support.AbstractService;
import egovframework.rte.itl.webservice.EgovWebServiceMessage;
import egovframework.rte.itl.webservice.EgovWebServiceMessageHeader;
import egovframework.rte.itl.webservice.service.EgovWebServiceClient;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EgovWebService
extends AbstractService {
    private Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final IntegrationDefinition integrationDefinition;
    private final EgovWebServiceMessageHeader defaultHeader;
    private EgovWebServiceClient client;

    public EgovWebService(String id, long defaultTimeout, IntegrationDefinition integrationDefinition, EgovWebServiceClient client) {
        super(id, defaultTimeout);
        if (integrationDefinition == null) {
            this.LOG.error((Object)"integrationDefinition is null");
            throw new IllegalArgumentException();
        }
        if (!integrationDefinition.isValid()) {
            this.LOG.error((Object)"integrationDefinition is invalid");
            throw new IllegalArgumentException();
        }
        if (!id.equals(integrationDefinition.getId())) {
            this.LOG.error((Object)"id not equals to integrationDefinition's id");
            throw new IllegalArgumentException();
        }
        if (client == null) {
            this.LOG.error((Object)"client is null");
            throw new IllegalArgumentException();
        }
        this.integrationDefinition = integrationDefinition;
        this.client = client;
        ServiceDefinition providerService = integrationDefinition.getProvider();
        SystemDefinition providerSystem = providerService.getSystem();
        OrganizationDefinition providerOrganization = providerSystem.getOrganization();
        SystemDefinition consumerSystem = integrationDefinition.getConsumer();
        OrganizationDefinition consumerOrganization = consumerSystem.getOrganization();
        this.defaultHeader = new EgovWebServiceMessageHeader(id, providerOrganization.getId(), providerSystem.getId(), providerService.getId(), consumerOrganization.getId(), consumerSystem.getId(), null, null, null, null, EgovIntegrationMessageHeader.ResultCode.OK, null);
    }

    public EgovIntegrationMessage createRequestMessage() {
        return new EgovWebServiceMessage(new EgovWebServiceMessageHeader(this.defaultHeader));
    }

    protected EgovIntegrationMessage doSend(EgovIntegrationMessage requestMessage) {
        this.LOG.debug((Object)("EgovWebSerivce doSend (requestMessage = " + requestMessage + ")"));
        if (!this.integrationDefinition.isUsing()) {
            this.LOG.info((Object)("Integration (id = \"" + this.id + "\") is not usable"));
            return new EgovWebServiceMessage(new EgovWebServiceMessageHeader(this.defaultHeader){
                {
                    this.setResultCode(EgovIntegrationMessageHeader.ResultCode.NOT_USABLE_INTEGRATION);
                }
            });
        }
        boolean validFrom = true;
        boolean validTo = true;
        Calendar now = Calendar.getInstance();
        if (this.integrationDefinition.getValidateFrom() != null) {
            boolean bl = validFrom = this.integrationDefinition.getValidateFrom().compareTo(now) <= 0;
        }
        if (this.integrationDefinition.getValidateTo() != null) {
            boolean bl = validTo = now.compareTo(this.integrationDefinition.getValidateTo()) <= 0;
        }
        if (!validFrom || !validTo) {
            this.LOG.info((Object)("Integration (id = \"" + this.id + "\") is invalid at " + now + " (validFrom = " + this.integrationDefinition.getValidateFrom() + ", validTo = " + this.integrationDefinition.getValidateTo() + ")"));
            return new EgovWebServiceMessage(new EgovWebServiceMessageHeader(this.defaultHeader){
                {
                    this.setResultCode(EgovIntegrationMessageHeader.ResultCode.INVALID_TIME);
                }
            });
        }
        if (!this.integrationDefinition.getProvider().isUsing()) {
            this.LOG.info((Object)("Integration (id = \"" + this.id + "\")'s provider service " + "is not usable"));
            return new EgovWebServiceMessage(new EgovWebServiceMessageHeader(this.defaultHeader){
                {
                    this.setResultCode(EgovIntegrationMessageHeader.ResultCode.NOT_USABLE_SERVICE);
                }
            });
        }
        requestMessage.getHeader().setRequestSendTime(now);
        EgovIntegrationMessage responseMessage = this.client.service(requestMessage);
        responseMessage.getHeader().setResponseReceiveTime(Calendar.getInstance());
        return responseMessage;
    }
}

