/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.xmlbeans;

import org.apache.xmlbeans.XMLStreamValidationException;
import org.apache.xmlbeans.XmlException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.xmlbeans.XmlBeansMarshallingFailureException;
import org.springframework.oxm.xmlbeans.XmlBeansSystemException;
import org.springframework.oxm.xmlbeans.XmlBeansUnmarshallingFailureException;
import org.springframework.oxm.xmlbeans.XmlBeansValidationFailureException;
import org.xml.sax.SAXException;

public class XmlBeansUtils {
    public static XmlMappingException convertXmlBeansException(Exception ex, boolean marshalling) {
        if (ex instanceof XMLStreamValidationException) {
            return new XmlBeansValidationFailureException((XMLStreamValidationException)ex);
        }
        if (ex instanceof XmlException) {
            XmlException xmlException = (XmlException)((Object)ex);
            if (marshalling) {
                return new XmlBeansMarshallingFailureException(xmlException);
            }
            return new XmlBeansUnmarshallingFailureException(xmlException);
        }
        if (ex instanceof SAXException) {
            SAXException saxException = (SAXException)ex;
            if (marshalling) {
                return new XmlBeansMarshallingFailureException(saxException);
            }
            return new XmlBeansUnmarshallingFailureException(saxException);
        }
        return new XmlBeansSystemException(ex);
    }
}

