/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.interceptor;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.springframework.xml.xsd.XsdSchema;
import org.springframework.xml.xsd.XsdSchemaCollection;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractValidatingInterceptor
extends TransformerObjectSupport
implements EndpointInterceptor,
InitializingBean {
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Resource[] schemas;
    private boolean validateRequest = true;
    private boolean validateResponse = false;
    private XmlValidator validator;

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public Resource[] getSchemas() {
        return this.schemas;
    }

    public void setSchema(Resource schema) {
        this.setSchemas(new Resource[]{schema});
    }

    public void setSchemas(Resource[] schemas) {
        Assert.notEmpty((Object[])schemas, (String)"schemas must not be empty or null");
        for (int i = 0; i < schemas.length; ++i) {
            Assert.notNull((Object)schemas[i], (String)"schema must not be null");
            Assert.isTrue((boolean)schemas[i].exists(), (String)("schema \"" + schemas[i] + "\" does not exit"));
        }
        this.schemas = schemas;
    }

    public void setXsdSchema(XsdSchema schema) throws IOException {
        this.validator = schema.createValidator();
    }

    public void setXsdSchemaCollection(XsdSchemaCollection schemaCollection) throws IOException {
        this.validator = schemaCollection.createValidator();
    }

    public void setValidateRequest(boolean validateRequest) {
        this.validateRequest = validateRequest;
    }

    public void setValidateResponse(boolean validateResponse) {
        this.validateResponse = validateResponse;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.validator == null && !ObjectUtils.isEmpty((Object[])this.schemas)) {
            Assert.hasLength((String)this.schemaLanguage, (String)"schemaLanguage is required");
            for (int i = 0; i < this.schemas.length; ++i) {
                Assert.isTrue((boolean)this.schemas[i].exists(), (String)("schema [" + this.schemas[i] + "] does not exist"));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Validating using " + StringUtils.arrayToCommaDelimitedString((Object[])this.schemas)));
            }
            this.validator = XmlValidatorFactory.createValidator((Resource[])this.schemas, (String)this.schemaLanguage);
        }
        Assert.notNull((Object)this.validator, (String)"Setting 'schema', 'schemas', 'xsdSchema', or 'xsdSchemaCollection' is required");
    }

    public boolean handleRequest(MessageContext messageContext, Object endpoint) throws IOException, SAXException, TransformerException {
        Source requestSource;
        if (this.validateRequest && (requestSource = this.getValidationRequestSource(messageContext.getRequest())) != null) {
            Object[] errors = this.validator.validate(requestSource);
            if (!ObjectUtils.isEmpty((Object[])errors)) {
                return this.handleRequestValidationErrors(messageContext, (SAXParseException[])errors);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Request message validated");
            }
        }
        return true;
    }

    protected boolean handleRequestValidationErrors(MessageContext messageContext, SAXParseException[] errors) throws TransformerException {
        for (int i = 0; i < errors.length; ++i) {
            this.logger.warn((Object)("XML validation error on request: " + errors[i].getMessage()));
        }
        return false;
    }

    public boolean handleResponse(MessageContext messageContext, Object endpoint) throws IOException, SAXException {
        Source responseSource;
        if (this.validateResponse && (responseSource = this.getValidationResponseSource(messageContext.getResponse())) != null) {
            Object[] errors = this.validator.validate(responseSource);
            if (!ObjectUtils.isEmpty((Object[])errors)) {
                return this.handleResponseValidationErrors(messageContext, (SAXParseException[])errors);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Response message validated");
            }
        }
        return true;
    }

    protected boolean handleResponseValidationErrors(MessageContext messageContext, SAXParseException[] errors) {
        for (int i = 0; i < errors.length; ++i) {
            this.logger.error((Object)("XML validation error on response: " + errors[i].getMessage()));
        }
        return false;
    }

    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        return true;
    }

    protected abstract Source getValidationRequestSource(WebServiceMessage var1);

    protected abstract Source getValidationResponseSource(WebServiceMessage var1);
}

