/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.mapping.AbstractMapBasedEndpointMapping;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathPayloadEndpointMapping
extends AbstractMapBasedEndpointMapping
implements InitializingBean {
    private String expressionString;
    private XPathExpression expression;
    private Properties namespaces;
    private TransformerFactory transformerFactory;

    public void setExpression(String expression) {
        this.expressionString = expression;
    }

    public void setNamespaces(Properties namespaces) {
        this.namespaces = namespaces;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.expressionString, (String)"expression is required");
        this.expression = this.namespaces == null ? XPathExpressionFactory.createXPathExpression((String)this.expressionString) : XPathExpressionFactory.createXPathExpression((String)this.expressionString, (Map)this.namespaces);
        this.transformerFactory = TransformerFactory.newInstance();
    }

    protected String getLookupKeyForMessage(MessageContext messageContext) throws Exception {
        Element payloadElement = this.getMessagePayloadElement(messageContext.getRequest());
        return this.expression.evaluateAsString((Node)payloadElement);
    }

    private Element getMessagePayloadElement(WebServiceMessage message) throws TransformerException {
        Transformer transformer = this.transformerFactory.newTransformer();
        DOMResult domResult = new DOMResult();
        transformer.transform(message.getPayloadSource(), domResult);
        return (Element)domResult.getNode().getFirstChild();
    }

    protected boolean validateLookupKey(String key) {
        return StringUtils.hasLength((String)key);
    }
}

