/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapEnvelope;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoap11Body;
import org.springframework.ws.soap.saaj.SaajSoap11Header;
import org.springframework.ws.soap.saaj.SaajSoap12Body;
import org.springframework.ws.soap.saaj.SaajSoap12Header;
import org.springframework.ws.soap.saaj.SaajSoapBody;
import org.springframework.ws.soap.saaj.SaajSoapBodyException;
import org.springframework.ws.soap.saaj.SaajSoapElement;
import org.springframework.ws.soap.saaj.SaajSoapHeader;
import org.springframework.ws.soap.saaj.SaajSoapHeaderException;

class SaajSoapEnvelope
extends SaajSoapElement
implements SoapEnvelope {
    private SaajSoapBody body;
    private SaajSoapHeader header;

    public SaajSoapEnvelope(SOAPEnvelope envelope) {
        super((SOAPElement)envelope);
    }

    public SoapBody getBody() {
        if (this.body == null) {
            try {
                SOAPBody saajBody = this.getImplementation().getBody(this.getSaajEnvelope());
                this.body = this.getImplementation().getName((SOAPElement)saajBody).getNamespaceURI().equals(SoapVersion.SOAP_11.getEnvelopeNamespaceUri()) ? new SaajSoap11Body(saajBody) : new SaajSoap12Body(saajBody);
            }
            catch (SOAPException ex) {
                throw new SaajSoapBodyException(ex);
            }
        }
        return this.body;
    }

    public SoapHeader getHeader() {
        if (this.header == null) {
            try {
                SOAPHeader saajHeader = this.getImplementation().getHeader(this.getSaajEnvelope());
                this.header = saajHeader != null ? (this.getImplementation().getName((SOAPElement)saajHeader).getNamespaceURI().equals(SoapVersion.SOAP_11.getEnvelopeNamespaceUri()) ? new SaajSoap11Header(saajHeader) : new SaajSoap12Header(saajHeader)) : null;
            }
            catch (SOAPException ex) {
                throw new SaajSoapHeaderException(ex);
            }
        }
        return this.header;
    }

    protected SOAPEnvelope getSaajEnvelope() {
        return (SOAPEnvelope)this.getSaajElement();
    }
}

