/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.http.AbstractHttpSenderConnection;

public class CommonsHttpConnection
extends AbstractHttpSenderConnection {
    private final HttpClient httpClient;
    private final PostMethod postMethod;
    private ByteArrayOutputStream requestBuffer;

    protected CommonsHttpConnection(HttpClient httpClient, PostMethod postMethod) {
        Assert.notNull((Object)httpClient, (String)"httpClient must not be null");
        Assert.notNull((Object)postMethod, (String)"postMethod must not be null");
        this.httpClient = httpClient;
        this.postMethod = postMethod;
    }

    public PostMethod getPostMethod() {
        return this.postMethod;
    }

    public void onClose() throws IOException {
        this.postMethod.releaseConnection();
    }

    public URI getUri() throws URISyntaxException {
        try {
            return new URI(this.postMethod.getURI().toString());
        }
        catch (URIException ex) {
            throw new URISyntaxException("", ex.getMessage());
        }
    }

    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
        this.requestBuffer = new ByteArrayOutputStream();
    }

    protected void addRequestHeader(String name, String value) throws IOException {
        this.postMethod.addRequestHeader(name, value);
    }

    protected OutputStream getRequestOutputStream() throws IOException {
        return this.requestBuffer;
    }

    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        this.postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(this.requestBuffer.toByteArray()));
        this.requestBuffer = null;
        this.httpClient.executeMethod((HttpMethod)this.postMethod);
    }

    protected int getResponseCode() throws IOException {
        return this.postMethod.getStatusCode();
    }

    protected String getResponseMessage() throws IOException {
        return this.postMethod.getStatusText();
    }

    protected long getResponseContentLength() throws IOException {
        return this.postMethod.getResponseContentLength();
    }

    protected InputStream getRawResponseInputStream() throws IOException {
        return this.postMethod.getResponseBodyAsStream();
    }

    protected Iterator getResponseHeaderNames() throws IOException {
        Header[] headers = this.postMethod.getResponseHeaders();
        String[] names = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            names[i] = headers[i].getName();
        }
        return Arrays.asList(names).iterator();
    }

    protected Iterator getResponseHeaders(String name) throws IOException {
        Header[] headers = this.postMethod.getResponseHeaders(name);
        String[] values = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            values[i] = headers[i].getValue();
        }
        return Arrays.asList(values).iterator();
    }
}

