/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.security.securedobject.impl;

import egovframework.rte.fdl.security.securedobject.EgovSecuredObjectService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.SecurityConfig;
import org.springframework.security.intercept.web.RequestKey;

public class SecuredObjectDAO {
    public static final String DEF_ROLES_AND_URL_QUERY = "SELECT a.resource_pattern url, b.authority authority FROM SECURED_RESOURCES a, SECURED_RESOURCES_ROLE b WHERE a.resource_id = b.resource_id AND a.resource_type = 'url' ORDER BY a.sort_order ";
    public static final String DEF_ROLES_AND_METHOD_QUERY = "SELECT a.resource_pattern method, b.authority authority FROM SECURED_RESOURCES a, SECURED_RESOURCES_ROLE b WHERE a.resource_id = b.resource_id AND a.resource_type = 'method' ORDER BY a.sort_order ";
    public static final String DEF_ROLES_AND_POINTCUT_QUERY = "SELECT a.resource_pattern pointcut, b.authority authority FROM SECURED_RESOURCES a, SECURED_RESOURCES_ROLE b WHERE a.resource_id = b.resource_id AND a.resource_type = 'pointcut' ORDER BY a.sort_order ";
    public static final String DEF_REGEX_MATCHED_REQUEST_MAPPING_QUERY_ORACLE10G = "SELECT a.resource_pattern uri, b.authority authority FROM secured_resources a, secured_resources_role b WHERE a.resource_id = b.resource_id AND a.resource_id =   ( SELECT resource_id FROM     ( SELECT resource_id, ROW_NUMBER() OVER (ORDER BY sort_order) resource_order FROM secured_resources c       WHERE REGEXP_LIKE ( :url, c.resource_pattern )       AND c.resource_type = 'url'       ORDER BY c.sort_order )    WHERE resource_order = 1 ) ";
    public static final String DEF_HIERARCHICAL_ROLES_QUERY = "SELECT a.child_role child, a.parent_role parent FROM ROLES_HIERARCHY a LEFT JOIN ROLES_HIERARCHY b on (a.child_role = b.parent_role) ";
    private String sqlRolesAndUrl = "SELECT a.resource_pattern url, b.authority authority FROM SECURED_RESOURCES a, SECURED_RESOURCES_ROLE b WHERE a.resource_id = b.resource_id AND a.resource_type = 'url' ORDER BY a.sort_order ";
    private String sqlRolesAndMethod = "SELECT a.resource_pattern method, b.authority authority FROM SECURED_RESOURCES a, SECURED_RESOURCES_ROLE b WHERE a.resource_id = b.resource_id AND a.resource_type = 'method' ORDER BY a.sort_order ";
    private String sqlRolesAndPointcut = "SELECT a.resource_pattern pointcut, b.authority authority FROM SECURED_RESOURCES a, SECURED_RESOURCES_ROLE b WHERE a.resource_id = b.resource_id AND a.resource_type = 'pointcut' ORDER BY a.sort_order ";
    private String sqlRegexMatchedRequestMapping = "SELECT a.resource_pattern uri, b.authority authority FROM secured_resources a, secured_resources_role b WHERE a.resource_id = b.resource_id AND a.resource_id =   ( SELECT resource_id FROM     ( SELECT resource_id, ROW_NUMBER() OVER (ORDER BY sort_order) resource_order FROM secured_resources c       WHERE REGEXP_LIKE ( :url, c.resource_pattern )       AND c.resource_type = 'url'       ORDER BY c.sort_order )    WHERE resource_order = 1 ) ";
    private String sqlHierarchicalRoles = "SELECT a.child_role child, a.parent_role parent FROM ROLES_HIERARCHY a LEFT JOIN ROLES_HIERARCHY b on (a.child_role = b.parent_role) ";
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public void setDataSource(DataSource dataSource) {
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    public String getSqlRolesAndUrl() {
        return this.sqlRolesAndUrl;
    }

    public void setSqlRolesAndUrl(String sqlRolesAndUrl) {
        this.sqlRolesAndUrl = sqlRolesAndUrl;
    }

    public String getSqlRolesAndMethod() {
        return this.sqlRolesAndMethod;
    }

    public void setSqlRolesAndMethod(String sqlRolesAndMethod) {
        this.sqlRolesAndMethod = sqlRolesAndMethod;
    }

    public String getSqlRolesAndPointcut() {
        return this.sqlRolesAndPointcut;
    }

    public void setSqlRolesAndPointcut(String sqlRolesAndPointcut) {
        this.sqlRolesAndPointcut = sqlRolesAndPointcut;
    }

    public String getSqlRegexMatchedRequestMapping() {
        return this.sqlRegexMatchedRequestMapping;
    }

    public void setSqlRegexMatchedRequestMapping(String sqlRegexMatchedRequestMapping) {
        this.sqlRegexMatchedRequestMapping = sqlRegexMatchedRequestMapping;
    }

    public String getSqlHierarchicalRoles() {
        return this.sqlHierarchicalRoles;
    }

    public void setSqlHierarchicalRoles(String sqlHierarchicalRoles) {
        this.sqlHierarchicalRoles = sqlHierarchicalRoles;
    }

    public LinkedHashMap getRolesAndResources(String resourceType) throws Exception {
        String sqlRolesAndResources;
        LinkedHashMap<String, ConfigAttributeDefinition> resourcesMap = new LinkedHashMap<String, ConfigAttributeDefinition>();
        boolean isResourcesUrl = true;
        if ("method".equals(resourceType)) {
            sqlRolesAndResources = this.getSqlRolesAndMethod();
            isResourcesUrl = false;
        } else if ("pointcut".equals(resourceType)) {
            sqlRolesAndResources = this.getSqlRolesAndPointcut();
            isResourcesUrl = false;
        } else {
            sqlRolesAndResources = this.getSqlRolesAndUrl();
        }
        List resultList = this.namedParameterJdbcTemplate.queryForList(sqlRolesAndResources, new HashMap());
        Iterator itr = resultList.iterator();
        String preResource = null;
        while (itr.hasNext()) {
            Map tempMap = (Map)itr.next();
            String presentResourceStr = (String)tempMap.get(resourceType);
            String presentResource = isResourcesUrl ? new RequestKey(presentResourceStr) : presentResourceStr;
            LinkedList<SecurityConfig> configList = new LinkedList<SecurityConfig>();
            if (preResource != null && presentResourceStr.equals(preResource)) {
                List preAuthList = (List)((ConfigAttributeDefinition)resourcesMap.get(presentResource)).getConfigAttributes();
                for (SecurityConfig tempConfig : preAuthList) {
                    configList.add(tempConfig);
                }
            }
            configList.add(new SecurityConfig((String)tempMap.get("authority")));
            ConfigAttributeDefinition cad = new ConfigAttributeDefinition(configList);
            resourcesMap.put(presentResource, cad);
            preResource = presentResourceStr;
        }
        return resourcesMap;
    }

    public LinkedHashMap getRolesAndUrl() throws Exception {
        return this.getRolesAndResources("url");
    }

    public LinkedHashMap getRolesAndMethod() throws Exception {
        return this.getRolesAndResources("method");
    }

    public LinkedHashMap getRolesAndPointcut() throws Exception {
        return this.getRolesAndResources("pointcut");
    }

    public ConfigAttributeDefinition getRegexMatchedRequestMapping(String url) throws Exception {
        ConfigAttributeDefinition attributes = null;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("url", url);
        List resultList = this.namedParameterJdbcTemplate.queryForList(this.getSqlRegexMatchedRequestMapping(), paramMap);
        Iterator itr = resultList.iterator();
        LinkedList<SecurityConfig> configList = new LinkedList<SecurityConfig>();
        while (itr.hasNext()) {
            Map tempMap = (Map)itr.next();
            configList.add(new SecurityConfig((String)tempMap.get("authority")));
        }
        if (configList.size() > 0) {
            attributes = new ConfigAttributeDefinition(configList);
            EgovSecuredObjectService.LOGGER.debug((Object)("Request Uri : " + url + ", matched Uri : " + ((Map)resultList.get(0)).get("uri") + ", mapping Roles : " + attributes));
        }
        return attributes;
    }

    public String getHierarchicalRoles() throws Exception {
        List resultList = this.namedParameterJdbcTemplate.queryForList(this.getSqlHierarchicalRoles(), new HashMap());
        Iterator itr = resultList.iterator();
        StringBuffer concatedRoles = new StringBuffer();
        while (itr.hasNext()) {
            Map tempMap = (Map)itr.next();
            concatedRoles.append(tempMap.get("child"));
            concatedRoles.append(" > ");
            concatedRoles.append(tempMap.get("parent"));
            concatedRoles.append("\n");
        }
        return concatedRoles.toString();
    }
}

