/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.transaction.config.TxNamespaceUtils;
import org.w3c.dom.Element;

class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    public static final String TRANSACTION_ADVISOR_BEAN_NAME = "org.springframework.transaction.config.internalTransactionAdvisor";
    public static final String TRANSACTION_ASPECT_BEAN_NAME = "org.springframework.transaction.config.internalTransactionAspect";
    private static final String TRANSACTION_ASPECT_CLASS_NAME = "org.springframework.transaction.aspectj.AnnotationTransactionAspect";
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionInterceptor;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$BeanFactoryTransactionAttributeSourceAdvisor;

    AnnotationDrivenBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String mode = element.getAttribute("mode");
        if ("aspectj".equals(mode)) {
            this.registerTransactionAspect(element, parserContext);
        } else {
            AopAutoProxyConfigurer.configureAutoProxyCreator(element, parserContext);
        }
        return null;
    }

    private void registerTransactionAspect(Element element, ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition(TRANSACTION_ASPECT_BEAN_NAME)) {
            RootBeanDefinition def = new RootBeanDefinition();
            def.setBeanClassName(TRANSACTION_ASPECT_CLASS_NAME);
            def.setFactoryMethodName("aspectOf");
            AnnotationDrivenBeanDefinitionParser.registerTransactionManager(element, (BeanDefinition)def);
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)def, TRANSACTION_ASPECT_BEAN_NAME));
        }
    }

    private static void registerTransactionManager(Element element, BeanDefinition def) {
        String transactionManagerName = element.hasAttribute("transaction-manager") ? element.getAttribute("transaction-manager") : DEFAULT_TRANSACTION_MANAGER_BEAN_NAME;
        def.getPropertyValues().addPropertyValue(TxNamespaceUtils.TRANSACTION_MANAGER_PROPERTY, (Object)new RuntimeBeanReference(transactionManagerName));
    }

    private static class AopAutoProxyConfigurer {
        private AopAutoProxyConfigurer() {
        }

        public static void configureAutoProxyCreator(Element element, ParserContext parserContext) {
            AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
            if (!parserContext.getRegistry().containsBeanDefinition(AnnotationDrivenBeanDefinitionParser.TRANSACTION_ADVISOR_BEAN_NAME)) {
                Object eleSource = parserContext.extractSource((Object)element);
                Class sourceClass = TxNamespaceUtils.getAnnotationTransactionAttributeSourceClass();
                RootBeanDefinition sourceDef = new RootBeanDefinition(sourceClass);
                sourceDef.setSource(eleSource);
                sourceDef.setRole(2);
                String sourceName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)sourceDef);
                RootBeanDefinition interceptorDef = new RootBeanDefinition(class$org$springframework$transaction$interceptor$TransactionInterceptor == null ? (class$org$springframework$transaction$interceptor$TransactionInterceptor = AnnotationDrivenBeanDefinitionParser.class$("org.springframework.transaction.interceptor.TransactionInterceptor")) : class$org$springframework$transaction$interceptor$TransactionInterceptor);
                interceptorDef.setSource(eleSource);
                interceptorDef.setRole(2);
                AnnotationDrivenBeanDefinitionParser.registerTransactionManager(element, (BeanDefinition)interceptorDef);
                interceptorDef.getPropertyValues().addPropertyValue("transactionAttributeSource", (Object)new RuntimeBeanReference(sourceName));
                String interceptorName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)interceptorDef);
                RootBeanDefinition advisorDef = new RootBeanDefinition(class$org$springframework$transaction$interceptor$BeanFactoryTransactionAttributeSourceAdvisor == null ? (class$org$springframework$transaction$interceptor$BeanFactoryTransactionAttributeSourceAdvisor = AnnotationDrivenBeanDefinitionParser.class$("org.springframework.transaction.interceptor.BeanFactoryTransactionAttributeSourceAdvisor")) : class$org$springframework$transaction$interceptor$BeanFactoryTransactionAttributeSourceAdvisor);
                advisorDef.setSource(eleSource);
                advisorDef.setRole(2);
                advisorDef.getPropertyValues().addPropertyValue("transactionAttributeSource", (Object)new RuntimeBeanReference(sourceName));
                advisorDef.getPropertyValues().addPropertyValue("adviceBeanName", (Object)interceptorName);
                if (element.hasAttribute("order")) {
                    advisorDef.getPropertyValues().addPropertyValue("order", (Object)element.getAttribute("order"));
                }
                parserContext.getRegistry().registerBeanDefinition(AnnotationDrivenBeanDefinitionParser.TRANSACTION_ADVISOR_BEAN_NAME, (BeanDefinition)advisorDef);
                CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), eleSource);
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)sourceDef, sourceName));
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)interceptorDef, interceptorName));
                compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)advisorDef, AnnotationDrivenBeanDefinitionParser.TRANSACTION_ADVISOR_BEAN_NAME));
                parserContext.registerComponent((ComponentDefinition)compositeDef);
            }
        }
    }
}

