/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.support;

import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationMessageHeader;
import egovframework.rte.itl.integration.EgovIntegrationService;
import egovframework.rte.itl.integration.EgovIntegrationServiceCallback;
import egovframework.rte.itl.integration.EgovIntegrationServiceResponse;
import egovframework.rte.itl.integration.message.simple.SimpleMessage;
import egovframework.rte.itl.integration.message.simple.SimpleMessageHeader;
import egovframework.rte.itl.integration.support.DefaultResponse;
import egovframework.rte.itl.integration.support.MessageSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractService
implements EgovIntegrationService {
    private Log LOG = LogFactory.getLog(this.getClass());
    protected String id;
    protected long defaultTimeout;

    public AbstractService(String id, long defaultTimeout) {
        if (!StringUtils.hasText((String)id)) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.defaultTimeout = defaultTimeout;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public String getId() {
        return this.id;
    }

    public EgovIntegrationServiceResponse sendAsync(EgovIntegrationMessage requestMessage) {
        this.LOG.debug((Object)"sendAsync called without Callback");
        if (requestMessage == null) {
            this.LOG.error((Object)"requestMessage is null");
            throw new IllegalArgumentException();
        }
        this.LOG.debug((Object)"Create MessageSender without Callback");
        MessageSender sender = new MessageSender(this, requestMessage, null);
        this.LOG.debug((Object)"Start MessageSender");
        sender.start();
        return new DefaultResponse(sender, this.defaultTimeout);
    }

    public void sendAsync(EgovIntegrationMessage requestMessage, EgovIntegrationServiceCallback callback) {
        this.LOG.debug((Object)"sendAsync called with Callback");
        if (requestMessage == null) {
            this.LOG.error((Object)"requestMessage is null");
            throw new IllegalArgumentException();
        }
        if (callback == null) {
            this.LOG.error((Object)"callback is null");
            throw new IllegalArgumentException();
        }
        this.LOG.debug((Object)"Create MessageSender with Callback");
        MessageSender sender = new MessageSender(this, requestMessage, callback);
        this.LOG.debug((Object)"Start MessageSender");
        sender.start();
    }

    public EgovIntegrationMessage sendSync(EgovIntegrationMessage requestMessage) {
        this.LOG.debug((Object)"sendSync called without timeout");
        if (requestMessage == null) {
            this.LOG.error((Object)"requestMessage is null");
            throw new IllegalArgumentException();
        }
        this.LOG.debug((Object)"call sendSync with defauleTimeout");
        return this.sendSync(requestMessage, this.defaultTimeout);
    }

    public EgovIntegrationMessage sendSync(EgovIntegrationMessage requestMessage, long timeout) {
        this.LOG.debug((Object)"sendSync called with timeout");
        if (requestMessage == null) {
            this.LOG.error((Object)"requestMessage is null");
            throw new IllegalArgumentException();
        }
        this.LOG.debug((Object)"Create MessageSender without Callback");
        MessageSender sender = new MessageSender(this, requestMessage, null);
        this.LOG.debug((Object)"Start MessageSender");
        sender.start();
        this.LOG.debug((Object)"Wait for the termination of MessageSender");
        try {
            sender.join(timeout);
        }
        catch (InterruptedException e) {
            this.LOG.debug((Object)"MessageSender was interrupted", (Throwable)e);
        }
        if (sender.isAlive()) {
            this.LOG.debug((Object)"MessageSender is alive over 'timeout'.");
            sender.interrupt();
            SimpleMessageHeader responseHeader = new SimpleMessageHeader(requestMessage.getHeader());
            responseHeader.setResultCode(EgovIntegrationMessageHeader.ResultCode.TIME_OUT);
            return new SimpleMessage(responseHeader);
        }
        this.LOG.debug((Object)"MessageSender finished to send and receive messages.");
        return sender.getResponseMessage();
    }

    protected abstract EgovIntegrationMessage doSend(EgovIntegrationMessage var1);
}

