/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.type.support;

import egovframework.rte.itl.integration.metadata.RecordTypeDefinition;
import egovframework.rte.itl.integration.metadata.RecordTypeFieldDefinition;
import egovframework.rte.itl.integration.metadata.dao.RecordTypeDefinitionDao;
import egovframework.rte.itl.integration.type.CircularInheritanceException;
import egovframework.rte.itl.integration.type.ListType;
import egovframework.rte.itl.integration.type.NoSuchTypeException;
import egovframework.rte.itl.integration.type.PrimitiveType;
import egovframework.rte.itl.integration.type.RecordType;
import egovframework.rte.itl.integration.type.Type;
import egovframework.rte.itl.integration.type.TypeLoader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeLoaderUsingMetadata
implements TypeLoader,
InitializingBean {
    private Log LOG = LogFactory.getLog(this.getClass());
    private RecordTypeDefinitionDao recordTypeDefinitionDao;
    private Map<String, Type> typePool = new HashMap<String, Type>();

    public TypeLoaderUsingMetadata() {
    }

    public TypeLoaderUsingMetadata(RecordTypeDefinitionDao recordTypeDefinitionDao) {
        this.recordTypeDefinitionDao = recordTypeDefinitionDao;
    }

    public void setRecordTypeDefinitionDao(RecordTypeDefinitionDao recordTypeDefinitionDao) {
        this.recordTypeDefinitionDao = recordTypeDefinitionDao;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.recordTypeDefinitionDao == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Type getType(String id) {
        return this.getType(id, null);
    }

    private Type getType(String id, Map<String, Type> loadingTypes) {
        this.LOG.debug((Object)("get Type(id = \"" + id + "\")"));
        if (id == null) {
            this.LOG.error((Object)"Argument 'id' is null");
            throw new NoSuchTypeException();
        }
        Type type = null;
        if (loadingTypes != null && (type = loadingTypes.get(id)) != null) {
            this.LOG.debug((Object)("Type(id = \"" + id + "\") exists in load hierachy : " + type));
            return type;
        }
        type = PrimitiveType.getPrimitiveType(id);
        if (type != null) {
            this.LOG.debug((Object)("Type(id = \"" + id + "\") is a primitive type : " + type));
            return type;
        }
        type = this.typePool.get(id);
        if (type != null) {
            this.LOG.debug((Object)("Type(id = \"" + id + "\") is already loaded : " + type));
            return type;
        }
        this.LOG.debug((Object)("Load new type(id= \"" + id + "\""));
        if (loadingTypes == null) {
            loadingTypes = new HashMap<String, Type>();
        }
        if (id.endsWith("[]")) {
            this.LOG.debug((Object)("Type(id = \"" + id + "\") is a list type"));
            type = new ListType(id, id, PrimitiveType.BOOLEAN);
            loadingTypes.put(id, type);
            Type elementType = this.getType(id.substring(0, id.length() - 2), loadingTypes);
            this.LOG.debug((Object)("ListType(id = \"" + id + "\")'s elementType = " + elementType));
            ((ListType)type).setElementType(elementType);
            loadingTypes.remove(id);
        } else {
            this.LOG.debug((Object)("Type(id = \"" + id + "\") is a record type"));
            RecordTypeDefinition recordTypeDefinition = this.recordTypeDefinitionDao.getRecordTypeDefinition(id);
            if (recordTypeDefinition == null) {
                this.LOG.error((Object)("No Such RecordTypeDefinition(id = \"" + id + "\""));
                throw new NoSuchTypeException();
            }
            if (!recordTypeDefinition.isValid()) {
                this.LOG.error((Object)("RecordTypeDefinition(id = \"" + id + "\" is invalid"));
                throw new NoSuchTypeException();
            }
            type = new RecordType(id, recordTypeDefinition.getName());
            loadingTypes.put(id, type);
            HashMap<String, RecordTypeDefinition> occurredTypes = new HashMap<String, RecordTypeDefinition>();
            HashMap<String, Type> fieldTypes = new HashMap<String, Type>();
            RecordTypeDefinition currentRecordTypeDefinition = recordTypeDefinition;
            while (currentRecordTypeDefinition != null) {
                if (occurredTypes.containsKey(currentRecordTypeDefinition.getId())) {
                    throw new CircularInheritanceException();
                }
                occurredTypes.put(currentRecordTypeDefinition.getId(), currentRecordTypeDefinition);
                for (Map.Entry<Object, Object> entry : currentRecordTypeDefinition.getFields().entrySet()) {
                    if (fieldTypes.containsKey(entry.getKey())) continue;
                    fieldTypes.put((String)entry.getKey(), this.getType(((RecordTypeFieldDefinition)entry.getValue()).getTypeId(), loadingTypes));
                }
                currentRecordTypeDefinition = currentRecordTypeDefinition.getParent();
            }
            if (this.LOG.isDebugEnabled()) {
                for (Map.Entry entry : fieldTypes.entrySet()) {
                    this.LOG.debug((Object)("RecordType(id = \"" + id + "\")'s field[" + (String)entry.getKey() + "] type = " + entry.getValue()));
                }
            }
            ((RecordType)type).setFieldTypes(fieldTypes);
            loadingTypes.remove(id);
        }
        this.typePool.put(id, type);
        return type;
    }
}

