/**
 * Copyright 2005 Darren L. Spurgeon
 * Copyright 2007 Jens Kapitza
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.ajaxtags.tags;

import javax.servlet.jsp.JspException;

/**
 * Rewrites HTML anchor tags (<A>), replacing the href attribute with an onclick
 * event so that retrieved content is loaded inside a region on the page.
 * 
 * @author Darren Spurgeon
 * @author Jens Kapitza
 * @version $Revision: 31 $ $Date: 2007/07/22 16:29:16 $ $Author: jenskapitza $
 */
public class AjaxAnchorsTag extends BaseAjaxBodyTag {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = -1732745741282114289L;

    /**
     * @see javax.servlet.jsp.tagext.Tag#doEndTag()
     */
    @Override
    public int doEndTag() throws JspException {
	out(ajaxAnchors());
	return EVAL_PAGE;
    }

}
