package egovframework.rte.cvpl.common;

import java.util.List;

import egovframework.rte.fdl.security.userdetails.util.EgovUserDetailsHelper;

/**
 * @Class Name : EgovCvplSessionAuth.java
 * @Description : 사용자 Session, authority get,set class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.02.01 박소윤 최초 생성
 * 
 * @author 실행환경 개발팀 박소윤
 * @since 2009.02.01
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */
public class EgovCvplSessionAuth {

    /** 사용자 아이디 */
    private String userId = "";

    /** 성명 */
    private String userName = "";

    /** 부서코드 */
    private String deptCode = "";

    /** 직책코드 */
    private String rspofcCode = "";

    /** 관리자권한 */
    private boolean isAdmin = false;

    /** 공무원권한 */
    private boolean isEgov = false;

    /** 일반사용자권한 */
    private boolean isUser = false;

    /** 로그인 확인 */
    private boolean isLogin = false;

    public String getUserId() {
        return userId;
    }

    public String getUserName() {
        return userName;
    }

    public String getDeptCode() {
        return deptCode;
    }

    public String getRspofcCode() {
        return rspofcCode;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }

    public void setRspofcCode(String rspofcCode) {
        this.rspofcCode = rspofcCode;
    }

    public boolean getIsAdmin() {
        List<String> authorities = EgovUserDetailsHelper.getAuthorities();
        if (authorities.contains("ROLE_ADMIN")) {
            isAdmin = true;
        }

        return isAdmin;
    }

    public boolean getIsEgov() {
        List<String> authorities = EgovUserDetailsHelper.getAuthorities();
        if (authorities.contains("ROLE_EGOV")) {
            isEgov = true;
        }

        return isEgov;
    }

    public boolean getIsUser() {
        List<String> authorities = EgovUserDetailsHelper.getAuthorities();
        if (authorities.contains("ROLE_USER")) {
            isUser = true;
        }

        return isUser;
    }

    public boolean getIsLogin() {
        Boolean isAuthenticated = EgovUserDetailsHelper.isAuthenticated();

        if (isAuthenticated.booleanValue()) {
            isLogin = true;
        }

        return isLogin;
    }

}
