package egovframework.rte.cvpl.service.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import egovframework.rte.cvpl.service.CvplCnsltVO;
import egovframework.rte.cvpl.service.CvplEmailVO;
import egovframework.rte.cvpl.service.CvplSearchVO;
import egovframework.rte.psl.dataaccess.EgovAbstractDAO;

/**
 * @Class Name : CvplCnsltDAO.java
 * @Description : CvplCnslt DAO Class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.03.05 천종덕 최초 생성
 * 
 * @author 실행환경 개발팀 천종덕
 * @since 2009.03.05
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */

@Repository("cvplCnsltDAO")
public class CvplCnsltDAO extends EgovAbstractDAO {

    /**
     * 글을 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplCnsltVO
     * @return 등록 결과
     * @exception Exception
     */
    public String insertCvplCnslt(CvplCnsltVO vo) throws Exception {
        return (String) insert("CvplCnsltDAO.insertCvplCnslt", vo);
    }

    /**
     * 답변을 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    public void insertAnswerCvplCnslt(CvplCnsltVO vo) throws Exception {
        update("CvplCnsltDAO.insertAnswerCvplCnslt", vo);
    }

    /**
     * 글을 수정한다.
     * 
     * @param vo
     *            - 수정할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    public void updateCvplCnslt(CvplCnsltVO vo) throws Exception {
        update("CvplCnsltDAO.updateCvplCnslt", vo);
    }

    /**
     * 답변을 수정한다.
     * 
     * @param vo
     *            - 수정할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    public void updateAnswerCvplCnslt(CvplCnsltVO vo) throws Exception {
        update("CvplCnsltDAO.updateAnswerCvplCnslt", vo);
    }

    /**
     * 글을 삭제한다.
     * 
     * @param vo
     *            - 삭제할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    public void deleteCvplCnslt(CvplCnsltVO vo) throws Exception {
        delete("CvplCnsltDAO.deleteCvplCnslt", vo);
    }

    /**
     * 답변을 삭제한다.
     * 
     * @param vo
     *            - 삭제할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    public void deleteAnswerCvplCnslt(CvplCnsltVO vo) throws Exception {
        update("CvplCnsltDAO.deleteAnswerCvplCnslt", vo);
    }

    /**
     * 글을 조회한다.
     * 
     * @param vo
     *            - 조회할 정보가 담긴 CvplCnsltVO
     * @return 조회한 글
     * @exception Exception
     */
    public CvplCnsltVO selectCvplCnslt(CvplCnsltVO vo) throws Exception {
        return (CvplCnsltVO) selectByPk("CvplCnsltDAO.selectCvplCnslt", vo);
    }

    /**
     * 글 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    public List selectCvplCnsltList(CvplSearchVO searchVO) throws Exception {
        return list("CvplCnsltDAO.selectCvplCnsltList", searchVO);
    }

    /**
     * 글 총 갯수를 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 총 갯수
     * @exception
     */
    public int selectCvplCnsltListTotCnt(CvplSearchVO searchVO) throws Exception {
        return Integer.parseInt(getSqlMapClientTemplate().queryForObject("CvplCnsltDAO.selectCvplCnsltListTotCnt",
                                                                         searchVO).toString());
    }

    /**
     * 검색어의 자동완성기능을 구현한다.
     * 
     * @param srchPrefix
     *            - 자동완성기능을 사용할 문자
     * @return 검색어리스트
     * @exception Exception
     */
    @SuppressWarnings("unchecked")
    public List<String> selectSearchKeywordList(String srchPrefix) throws Exception {
        return (List<String>) getSqlMapClientTemplate().queryForList("CvplCnsltDAO.selectSearchKeywordList", srchPrefix);
    }

    /**
     * 검색어의 중복을 체크한다.
     * 
     * @param dupSrchKeyword
     *            - 중복을 체크할 검색어
     * @return searchKeyword
     * @exception Exception
     */
    public String checkDupSearchKeywordList(String dupSrchKeyword) throws Exception {
        return (String) getSqlMapClientTemplate().queryForObject("CvplCnsltDAO.checkDupSearchKeywordList",
                                                                 dupSrchKeyword);
    }

    /**
     * 검색어를 등록한다.
     * 
     * @param searchKeyword
     *            - 등록할 검색어
     * @return searchKeyword
     * @exception Exception
     */
    public void insertSearchKeywordList(String searchKeyword) throws Exception {
        insert("CvplCnsltDAO.insertSearchKeywordList", searchKeyword);
    }

    /**
     * 엑셀파일 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    public List excelDownCvplCnsltList(CvplSearchVO searchVO) throws Exception {
        return list("CvplCnsltDAO.excelDownCvplCnsltList", searchVO);
    }

    /**
     * 메일송신 목록을 조회한다.
     * 
     * @param
     * @return 메일송신 목록
     * @exception Exception
     */
    public List<CvplEmailVO> selectCvplEmail() throws Exception {
        return list("CvplCnsltDAO.selectCvplEmail", null);
    }

    /**
     * 메일송신 완료를 셋팅한다.
     * 
     * @param vo
     *            - 셋팅할 정보가 담긴 CvplEmailVO
     * @return void형
     * @exception Exception
     */
    public void updateCvplEmailSend(CvplEmailVO vo) throws Exception {
        update("CvplCnsltDAO.updateCvplEmailSend", vo);
    }

    /**
     * 나의 민원 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 나의 민원 목록
     * @exception Exception
     */
    public List selectCvplCnsltMyList(CvplSearchVO searchVO) throws Exception {
        return list("CvplCnsltDAO.selectCvplCnsltMyList", searchVO);
    }

    /**
     * 나의민원 엑셀파일 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 나의민원 목록
     * @exception Exception
     */
    public List excelDownCvplCnsltMyList(CvplSearchVO searchVO) throws Exception {
        return list("CvplCnsltDAO.excelDownCvplCnsltMyList", searchVO);
    }

    /**
     * BEST 민원으로 셋팅한다.
     * 
     * @param vo
     *            - 셋팅할 정보가 담긴 CvplCnsltVO vo
     * @return void형
     * @exception Exception
     */
    public void updateCvplCnsltBest(CvplCnsltVO vo) throws Exception {
        update("CvplCnsltDAO.updateCvplCnsltBest", vo);
    }

    /**
     * BEST 민원을 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplCnsltVO vo
     * @return void형
     * @exception Exception
     */
    public void insertBestCvplCnslt(CvplCnsltVO vo) throws Exception {
        insert("CvplCnsltDAO.insertBestCvplCnslt", vo);
    }

}
