package egovframework.rte.cvpl.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import egovframework.rte.cvpl.service.EgovCvplCmmnCdService;
import egovframework.rte.fdl.cmmn.AbstractServiceImpl;

/**
 * @Class Name : EgovCvplUserServiceImpl.java
 * @Description : EgovCvplUser Business Implement class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.02.01 박소윤 최초 생성
 * 
 * @author 실행환경 개발팀 박소윤
 * @since 2009.02.01
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */

@Service("cvplCmmnCdService")
public class EgovCvplCmmnCdServiceImpl extends AbstractServiceImpl implements EgovCvplCmmnCdService {

    @Resource(name = "cvplCmmnCdDAO")
    private CvplCmmnCdDAO cvplCmmnCdDAO;

    /**
     * 공통코드 셀렉트 리스트를 조회한다.
     * 
     * @param 조회할
     *            메인 공통코드 001 : 민원공개여부, 002 : 부서, 003 : 직책
     * @return "cvplCmmnCdVO"
     * @exception Exception
     */
    public List selectCvplCmmnCdList() throws Exception {
        return cvplCmmnCdDAO.selectCvplCmmnCdList();
    }

}
