package egovframework.rte.cvpl.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import egovframework.rte.cvpl.service.CvplSearchVO;
import egovframework.rte.cvpl.service.CvplUserVO;
import egovframework.rte.cvpl.service.EgovCvplUserService;
import egovframework.rte.fdl.cmmn.AbstractServiceImpl;
import egovframework.rte.fdl.crypto.EgovEDcryptionService;
import egovframework.rte.fdl.string.EgovStringUtil;

/**
 * @Class Name : EgovCvplUserServiceImpl.java
 * @Description : EgovCvplUser Business Implement class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.02.01 박소윤 최초 생성
 * 
 * @author 실행환경 개발팀 박소윤
 * @since 2009.02.01
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */

@Service("cvplUserService")
public class EgovCvplUserServiceImpl extends AbstractServiceImpl implements EgovCvplUserService {

    @Resource(name = "cvplUserDAO")
    private CvplUserDAO cvplUserDAO;

    /** Encryption, Decryption */
    @Resource(name = "cryptolerTxt")
    private EgovEDcryptionService cryptoTxt;

    /** Encryption, Decryption */
    @Resource(name = "cryptolerPwd")
    private EgovEDcryptionService cryptoPwd;

    /**
     * 사용자 가입
     * 
     * @param vo
     *            - 사용자 가입할 정보가 담긴 CvplUserVO
     * @return 등록 결과
     * @exception Exception
     */
    public String insertCvplUser(CvplUserVO vo) throws Exception {
        log.debug(vo.toString());

        /** password Encryption */
        String strPwd = vo.getPassword();
        if (strPwd == null || strPwd.length() == 0) {
            strPwd = "1";
        } else {
            /** Encryption */
            cryptoPwd.setPlainDigest(true);
            cryptoPwd.setConfig(-1, strPwd);
            cryptoPwd.setAlgorithm("MD5");

            byte ret_Pwdencryt[] = cryptoPwd.encrypt();
            String strPwdEncryt = new String(ret_Pwdencryt);
            strPwd = strPwdEncryt;
        }
        vo.setPassword(strPwd);

        /** ihidnum Encryption */
        String strIhidnum = vo.getIhidnum();
        if (strIhidnum == null || strIhidnum.length() == 0) {
            strIhidnum = "";
        } else {
            /** Encryption */
            cryptoTxt.setComformStr("Egov");
            cryptoTxt.setConfig(-1, strIhidnum);
            byte ret_encryt[] = cryptoTxt.encrypt();
            String strEncryt = new String(ret_encryt);
            strIhidnum = strEncryt;
        }
        vo.setIhidnum(strIhidnum);

        cvplUserDAO.insertCvplUser(vo);
        cvplUserDAO.insertCvplUserAuth(vo);

        return vo.getUserId();
    }

    /**
     * 사용자 수정
     * 
     * @param vo
     *            - 사용자 수정할 정보가 담긴 CvplUserVO
     * @return void형
     * @exception Exception
     */
    public void updateCvplUser(CvplUserVO vo) throws Exception {

        /** ihidnum Encryption */
        String strIhidnum = vo.getIhidnum();
        if (strIhidnum == null || strIhidnum.length() == 0) {
            strIhidnum = "";
        } else {
            /** Encryption */
            cryptoTxt.setComformStr("Egov");
            cryptoTxt.setConfig(-1, strIhidnum);
            byte ret_encryt[] = cryptoTxt.encrypt();
            String strEncryt = new String(ret_encryt);
            strIhidnum = strEncryt;
        }
        vo.setIhidnum(strIhidnum);

        cvplUserDAO.updateCvplUser(vo);
    }

    /**
     * 사용자 삭제
     * 
     * @param vo
     *            - 삭제할 정보가 담긴 CvplUserVO
     * @return void형
     * @exception Exception
     */
    public void deleteCvplUser(CvplUserVO vo) throws Exception {
        cvplUserDAO.deleteCvplUserAuth(vo);
        cvplUserDAO.deleteCvplUser(vo);
    }

    /**
     * 사용자를 조회한다.
     * 
     * @param vo
     *            - 조회할 정보가 담긴 CvplUserVO
     * @return 조회한 글
     * @exception Exception
     */
    public CvplUserVO selectCvplUser(CvplUserVO vo) throws Exception {
        CvplUserVO resultVO = cvplUserDAO.selectCvplUser(vo);

        String strIhidnum1 = "";
        String strIhidnum2 = "";

        if (resultVO == null) {
            throw processException("info.nodata.msg");
        } else {
            if (resultVO.getIhidnum() == null || resultVO.getIhidnum().length() == 0) {
                strIhidnum1 = "";
                strIhidnum2 = "";
            } else {
                /** Decryption */
                cryptoTxt.getComformStr("Egov");
                cryptoTxt.setConfig(-1, resultVO.getIhidnum());
                byte ret_decrypt[] = cryptoTxt.decrypt();
                String strDecrypt = new String(ret_decrypt);

                if (13 == strDecrypt.length()) {
                    strIhidnum1 = EgovStringUtil.toSubString(strDecrypt, 0, 6);
                    strIhidnum2 = EgovStringUtil.toSubString(strDecrypt, 6);
                } else {
                    strIhidnum1 = strDecrypt;
                }
            }

            resultVO.setIhidnum1(strIhidnum1);
            resultVO.setIhidnum2(strIhidnum2);
        }

        return resultVO;
    }

    /**
     * 사용자 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 사용자 목록
     * @exception Exception
     */
    public List selectCvplUserList(CvplSearchVO searchVO) throws Exception {
        return cvplUserDAO.selectCvplUserList(searchVO);
    }

    /**
     * 사용자 총 갯수를 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 사용자 총 갯수
     * @exception
     */
    public int selectCvplUserListTotCnt(CvplSearchVO searchVO) {
        return cvplUserDAO.selectCvplUserListTotCnt(searchVO);
    }

    /**
     * check for duplicate user id.
     * 
     * @param vo
     *            - 검색할 사용자 아이디가 담긴 VO
     * @return 사용 가능한 아이디 일 경우 <code>true</code> 사용 중인 아이디 일 경우
     *         <code>false</code>
     * @exception Exception
     */
    public boolean checkCvplUserIdDplc(CvplUserVO cvplUserVO) throws Exception {
        int count = 0;
        count = cvplUserDAO.checkCvplUserIdDplc(cvplUserVO);
        return !(count == 0);
    }

    /**
     * 엑셀파일 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    public List excelDownCvplUserList(CvplSearchVO searchVO) throws Exception {
        return cvplUserDAO.excelDownCvplUserList(searchVO);
    }

}
