package egovframework.rte.cvpl.util;

import javax.annotation.Resource;

import org.apache.commons.mail.MultiPartEmail;
import org.springframework.stereotype.Service;

import egovframework.rte.fdl.cmmn.trace.LeaveaTrace;
import egovframework.rte.fdl.property.EgovPropertyService;

/**
 * @Class Name : EgovCvplCnsltMailService.java
 * @Description : EgovCvplCnsltMailService class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.03.05 천종덕 최초 생성
 * 
 * @author 실행환경 개발팀 천종덕
 * @since 2009.03.05
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */
@Service("egovCvplCnsltMailService")
public class EgovCvplCnsltMailService {

    @Resource(name = "leaveaTrace")
    private LeaveaTrace traceObj;

    /** 메일 받는사람 이름 */
    private String emailName = "";

    /** 메일 주소 */
    private String emailAddr = "";

    /** 메일 제목 */
    private String emailSj = "";

    /** 메일 내용 */
    private String emailContents = "";

    /** EgovPropertyService */
    @Resource(name = "propertiesService")
    protected EgovPropertyService propertiesService;

    /**
     * email을 보낸다.
     * 
     * @param
     * @return 성공여부
     * @exception Exception
     */
    public String sendEmail() {
        MultiPartEmail email = new MultiPartEmail();
        String sResult = "";

        try {
            email.setHostName(propertiesService.getString("emailServer"));
            email.setSSL(true);
            email.setSmtpPort(465);
            email.setAuthentication(propertiesService.getString("emailAuthId"),
                                    propertiesService.getString("emailAuthPwd"));

            email.addTo(emailAddr, emailName);
            email.setFrom(propertiesService.getString("emailFromAddr"), propertiesService.getString("emailFromName"));
            email.setSubject(emailSj);
            email.setMsg(emailContents);

            email.send();

            sResult = "SUCCESS";
            return sResult;
        } catch (Exception e) {
            traceObj.trace("trace.mail.fail", this.getClass());
            sResult = "FAIL";
            return sResult;
        } finally {
            email = null;
        }
    }

    public String getEmailName() {
        return emailName;
    }

    public void setEmailName(String emailName) {
        this.emailName = emailName;
    }

    public String getEmailAddr() {
        return emailAddr;
    }

    public void setEmailAddr(String emailAddr) {
        this.emailAddr = emailAddr;
    }

    public String getEmailSj() {
        return emailSj;
    }

    public void setEmailSj(String emailSj) {
        this.emailSj = emailSj;
    }

    public String getEmailContents() {
        return emailContents;
    }

    public void setEmailContents(String emailContents) {
        this.emailContents = emailContents;
    }

}
