package egovframework.rte.cvpl.util;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Resource;

import egovframework.rte.cvpl.service.CvplFaqVO;
import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationService;
import egovframework.rte.itl.webservice.EgovWebServiceContext;

public class EgovWebServiceClientRegisterFaq {

    @Resource(name = "egovWebServiceContext")
    private EgovWebServiceContext context;

    private String integrationId;

    /**
     * @param context
     *            the context to set
     */
    public void setContext(EgovWebServiceContext context) {
        this.context = context;
    }

    /**
     * @param integrationId
     *            the integrationId to set
     */
    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public boolean registerFaq(final CvplFaqVO vo) {
        EgovIntegrationService service = context.getService(integrationId);

        EgovIntegrationMessage requestMessage = service.createRequestMessage();
        Map<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("faqNo", vo.getFaqNo());
        requestBody.put("faqSj", vo.getFaqSj());
        requestBody.put("faqContents", vo.getFaqContents());
        requestBody.put("faqAtch1", vo.getFaqAtch1());
        requestBody.put("faqAtch2", vo.getFaqAtch2());
        requestBody.put("registTime", vo.getOrgRegistTime());
        requestBody.put("userId", vo.getUserId());
        requestBody.put("admnstmachCode", vo.getAdmnstmachCode());
        requestBody.put("bestYn", vo.getBestYn());
        requestMessage.setBody(requestBody);

        EgovIntegrationMessage responseMessage = service.sendSync(requestMessage);

        return (Boolean) responseMessage.getBody().get("result");
    }
}
