<%@ page contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="validator" uri="http://www.springmodules.org/tags/commons-validator" %>
<%
 /**
  * @Class Name : egovCvplCnsltRegister.java
  * @Description : CvplCnslt Register 화면
  * @Modification Information
  * @
  * @  수정일         수정자                   수정내용
  * @ -------    --------    ---------------------------
  * @ 2009.03.05    천종덕          최초 생성
  *
  *  @author 실행환경 개발팀 천종덕
  *  @since 2009.03.05
  *  @version 1.0
  *  @see
  *  
  *  Copyright (C) 2009 by MOPAS  All right reserved.
  */
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="<c:url value='/css/egovframework/egovCvpl.css'/>"/>
<title><spring:message code="pageTitle.egovCvplCnsltRegister" /> <c:out value="${registerFlag}"/> </title>
<!--For Commons Validator Client Side-->
<script type="text/javascript" src="<c:url value="/cmmn/validator.js"/>"></script>
<validator:javascript formName="cvplCnsltVO" staticJavascript="false" xhtml="true" cdata="false"/>

<script type="text/javascript" src="<c:url value='/js/egovframework/rte/cvpl/multifile.js'/>"></script>
<script type="text/javaScript" language="javascript" defer="defer">
<!--
var multi_selector = new MultiSelector( document.getElementById( 'cvplFileList' ), 2 );
multi_selector.addElement( document.getElementById( 'cvplFileUploader' ) );

function fn_egov_list_cvplcnslt() {
	document.registerForm.action = "<c:url value='/cvpl/egovCvplCnsltList.do'/>";
	document.registerForm.submit();		
}

function fn_egov_add_cvplcnslt_clientVal() {
	if(!validateCvplCnsltVO(document.registerForm)){
        return;
    }else{
    	document.registerForm.action = "<c:url value='/cvpl/addCvplCnslt.do'/>";
    	document.registerForm.submit();		
    }
}

function fn_egov_add_cvplcnslt_serverVal() {
	document.registerForm.action = "<c:url value='/cvpl/addCvplCnslt.do'/>";
	document.registerForm.submit();		
}

function fn_egov_cancel_cvplcnslt() {
	document.registerForm.reset();
}

-->
</script>
</head>
<body>
<!-- Top -->
<jsp:include page="/cvpl/egovCvplTop.do"/>
<!-- //Top -->
<!-- Left -->
<jsp:include page="/cvpl/egovCvplLeft.do"/>
<!-- //Left -->
<!-- Center -->
<div id="content">
	<!-- 타이틀 -->
	<div id="title">
		<ul>
			<li><img src="<c:url value='/images/egovframework/rte/title_dot.gif'/>"> <spring:message code='pageTitle.egovCvplCnsltRegister'/> </li>
		</ul>
	</div>
	<!-- // 타이틀 -->
	<form:form commandName="cvplCnsltVO" name="registerForm" enctype="multipart/form-data" method="post">
	<div id="table">
		  <table width="100%" border="1" cellpadding="0" cellspacing="0" bordercolor="#D3E2EC" bordercolordark="#FFFFFF" style="BORDER-TOP:#C2D0DB 2px solid; BORDER-LEFT:#ffffff 1px solid; BORDER-RIGHT:#ffffff 1px solid; BORDER-BOTTOM:#C2D0DB 1px solid; border-collapse: collapse;">
			<colgroup>
					<col width="150">
					<col width="">
			</colgroup>
			<tr>
				<td class="tbtd_caption"><spring:message code='title.cvpl.user' /></td>
				<td class="tbtd_content"><form:input path="userName" cssClass="txt" readonly="readonly" /></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.cvpl.cvplSj' /></td>
				<td class="tbtd_content"><form:input path="cvplSj" cssClass="txt" size="70"/>
							&nbsp;<br><br><form:errors path="cvplSj" /></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.cvpl.cvplOthbcCode' /></td>
				<td class="tbtd_content">
					<form:select path="cvplOthbcCode">
						<form:options items="${cvplOthbcCategory}" itemValue="code" itemLabel="label" />
					</form:select>
				</td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.cvpl.cvplContents' /></td>
				<td class="tbtd_content"><form:textarea path="cvplContents" rows="5" cols="58" /></td>
				</tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.cvpl.cvplAtch1' /></td>
				<td class="tbtd_content"><input name="file_1" id="cvplFileUploader" type="file" class="txt" size="60"/></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.cvpl.cvplAtch2' /></td>
				<td class="tbtd_content"><div id="cvplFileList"></div></td>
			  </tr>
			</table>
	  </div>
		<div id="sysbtn">
			<ul>
			<li><span class="btn_blue_l"><a href="javascript:fn_egov_list_cvplcnslt();"><spring:message code='button.list' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
			<li><span class="btn_blue_l"><a href="javascript:fn_egov_add_cvplcnslt_clientVal();"><spring:message code='button.register.clientVal' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
			<li><span class="btn_blue_l"><a href="javascript:fn_egov_add_cvplcnslt_serverVal();"><spring:message code='button.register.serverVal' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
			<li><span class="btn_blue_l"><a href="javascript:fn_egov_cancel_cvplcnslt();"><spring:message code='button.reset' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li></ul>
		</div>
	</div>
	<!-- 검색조건 유지 -->
	<input type="hidden" name="searchCondition" value="<c:out value='${searchVO.searchCondition}'/>"/>
	<input type="hidden" name="searchKeyword" value="<c:out value='${searchVO.searchKeyword}'/>"/>
	<input type="hidden" name="pageIndex" value="<c:out value='${searchVO.pageIndex}'/>"/>
	</form:form>
</div>
<!-- /Center -->
<!-- Bottom -->
<jsp:include page="/cvpl/EgovCvplBottom.do"/>
<!-- //Bottom -->
</body>
</html>

