<%@ page contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="ui" uri="http://egovframework.gov/ctl/ui"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="ajax" uri="http://ajaxtags.sourceforge.net/tags/ajaxtags" %>
<%
 /**
  * @Class Name : egovCvplFaqList.java
  * @Description : CvplFaq List 화면
  * @Modification Information
  * @
  * @  수정일         수정자                   수정내용
  * @ -------    --------    ---------------------------
  * @ 2009.03.05    천종덕          최초 생성
  *
  *  @author 실행환경 개발팀 천종덕
  *  @since 2009.03.05
  *  @version 1.0
  *  @see
  *  
  *  Copyright (C) 2009 by MOPAS  All right reserved.
  */
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><spring:message code="pageTitle.egovCvplFaqList" /></title>
<script type="text/javascript" src="<c:url value='/ajaxtags/js/prototype.js'/>"></script>
<script type="text/javascript" src="<c:url value='/ajaxtags/js/scriptaculous/scriptaculous.js'/>"></script>
<script type="text/javascript" src="<c:url value='/ajaxtags/js/overlibmws/overlibmws.js'/>"></script>
<script type="text/javascript" src="<c:url value='/ajaxtags/js/ajaxtags.js'/>"></script>
<link type="text/css" rel="stylesheet" href="<c:url value='/ajaxtags/css/ajaxtags.css'/>"/>
<link type="text/css" rel="stylesheet" href="<c:url value='/ajaxtags/css/displaytag.css'/>"/>
<link type="text/css" rel="stylesheet" href="<c:url value='/css/egovframework/egovCvpl.css'/>"/>
<script type="text/javaScript" language="javascript" defer="defer">
<!--
function fn_egov_list_cvplfaq() {
	document.listForm.action = "<c:url value='/cvpl/egovCvplFaqList.do'/>";
	document.listForm.submit();		
}

function fn_egov_download_excel() {
	document.listForm.action = "<c:url value='/cvpl/excelDownCvplFaqList.do'/>";
	document.listForm.submit();		
}

function fn_egov_view_cvplfaq(id) {
	document.listForm.selectedId.value = id;
	document.listForm.action = "<c:url value='/cvpl/viewCvplFaqView.do'/>";
	document.listForm.submit();		
}

function fn_egov_addview_cvplfaq() {
	document.listForm.action = "<c:url value='/cvpl/addCvplFaqView.do'/>";
	document.listForm.submit();		
}

function fn_egov_link_page(pageNo){
	document.listForm.pageIndex.value = pageNo;
	document.listForm.action = "<c:url value='/cvpl/egovCvplFaqList.do'/>";
   	document.listForm.submit();
}
-->
</script>
</head>
<body>
<!-- Top -->
<jsp:include page="/cvpl/egovCvplTop.do"/>
<!-- //Top -->
<!-- Left -->
<jsp:include page="/cvpl/egovCvplLeft.do"/>
<!-- //Left -->
<!-- Center -->
<div id="content">
	<!-- 타이틀 -->
	<div id="title">
		<ul>
			<li><img src="<c:url value='/images/egovframework/rte/title_dot.gif'/>"> <spring:message code='pageTitle.egovCvplFaqList'/></li>
		</ul>
	</div>
	<!-- // 타이틀 -->
	<form:form commandName="searchVO" name="listForm" method="post">
		<div style='margin:0; padding:10px 0 10px 0; width:680px;'>
			<table border="0" cellpadding="0" cellspacing="0" align="right">
				<tr style='margin:0;'>
					<td style='padding:0 0 0 3px;'>
						<form:select path="searchCondition">
							<form:option value="0"><spring:message code="search.subject" /></form:option>
							<form:option value="1"><spring:message code="search.user" /></form:option>
							<form:option value="2"><spring:message code="search.contents" /></form:option>
						</form:select>
					</td>
					<td style='padding:0 0 0 3px;'>
						<form:input path="searchKeyword" cssClass="txt"/>
					</td>
					<td style='padding:0 0 0 3px;'>
						<a href="javascript:fn_egov_list_cvplfaq();"><img src="<c:url value='/images/egovframework/rte/'/><spring:message code='image.search' />" border="0" class="top"></a>
					</td>
				</tr>
			</table> 
		</div>
		<!-- LIST -->
		<input name="selectedId" type="hidden" />
		<div id="table">
		   <table width="100%" border="0" cellpadding="0" cellspacing="0">
				<colgroup>
					<col width="40">
					<col width="100">
					<col width="">
					<col width="80">
				</colgroup>		  
				<tr>
					<th align="center"><spring:message code="title.faq.num" /></th>
					<th align="center"><spring:message code="title.faq.faqNo" /></th>
					<th align="center"><spring:message code="title.faq.faqSj" /></th>
					<th align="center"><spring:message code="title.faq.user" /></th>
				</tr>
				<c:forEach var="result" items="${resultList}" varStatus="status">
				<tr>
					<td align="center" class="listtd"><c:out value="${status.count}"/></td>
					<td align="center" class="listtd"><a href="javascript:fn_egov_view_cvplfaq('<c:out value="${result.faqNo}"/>')"><c:out value="${result.faqNo}"/></a></td>
					<td align="left" class="listtd"><c:out value="${result.faqSj}"/></td>
					<td align="center" class="listtd"><c:out value="${result.userName}"/></td>
				</tr>
				</c:forEach>
			</table>
		</div>
		<div id="paging">
			<ui:pagination paginationInfo = "${paginationInfo}"
					   type="image"
					   jsFunction="fn_egov_link_page"
					   />
			<form:hidden path="pageIndex" />
		</div>
		<div id="sysbtn">
			<ul>
			<li><span class="btn_blue_l"><a href="javascript:fn_egov_download_excel();"><spring:message code='button.excelDown' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
			<c:if test="${(egovCvplSessionAuth.isAdmin || egovCvplSessionAuth.isEgov)}">
			<li><span class="btn_blue_l"><a href="javascript:fn_egov_addview_cvplfaq();"><spring:message code='button.register' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
			</c:if>
			</ul>
		</div>
	</form:form>
	<ajax:autocomplete 
	  baseUrl="${pageContext.request.contextPath}/cvpl/egovCvplFaqSearchAjax.do" 
	  source="searchKeyword" 
	  target="searchKeyword" 
	  className="autocomplete" 
	  minimumCharacters="1" />
</div>
<!-- /Center -->
<!-- Bottom -->
<jsp:include page="/cvpl/EgovCvplBottom.do"/>
<!-- //Bottom -->
</body>
</html>
