<%@ page contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="validator" uri="http://www.springmodules.org/tags/commons-validator" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%
 /**
  * Class Name : EgovCvplUserLoginRegister.jsp
  * Description : Civil Appeal Sample 사용자 가입 Register 화면
  * Modification Information
  * 
  *   수정일         수정자                   수정내용
  *  -------    --------    ---------------------------
  *  2009.02.01   박소윤         최초 생성
  *
  * author 실행환경 개발팀 박소윤
  * since 2009.02.01
  *  
  * Copyright (C) 2009 by MOPAS  All right reserved.
  */
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="<c:url value='/css/egovframework/egovCvpl.css'/>"/>
<title><spring:message code="pageTitle.egovCvplUserRegister" /></title>

<!--For Commons Validator Client Side-->
<script type="text/javascript" src="<c:url value="/cmmn/validator.js"/>"></script>
<validator:javascript formName="cvplUserVO" staticJavascript="false" xhtml="true" cdata="false"/>

<script type="text/javaScript" language="javascript" defer="defer" src="<c:url value='/js/egovframework/rte/cvpl/cvpluser_cmmn.js'/>"></script>
<script type="text/javaScript" language="javascript" defer="defer">
<!--

function fn_egov_save_cvpluser() {
	frm = document.registerForm;
	
    frm.ihidnum.value = frm.ihidnum1.value + frm.ihidnum2.value;
	
	if(!validateCvplUserVO(frm)){
        return;
    }else{
    	if( frm.password.value == frm.passwordCnfirm.value ) {
    		frm.target = "_self";
            frm.action = "<c:url value='/cvpl/addCvplUser.do'/>";
            frm.submit();
        } else {
            alert("<spring:message code='info.cvpl.passwordCheck.msg'/>");
            return;
        }
    }
}

function fn_egov_reset_cvpluser() {
	frm = document.registerForm;
	
	frm.reset();
}

function fn_egov_cancel_cvpluser() {
	frm = document.registerForm;
	
    frm.reset();
    frm.action = "<c:url value='/cvpl/egovCvplLogin.do'/>";
    frm.submit();
}


function fn_egov_check_userid() {
	frm = document.registerForm;
  
	p_checkDplc = window.open("<c:url value='/cvpl/checkCvplUserIdDplc.do'/>","p_checkDplc"
			  , "left=300,top=200,width=350,height=200,marginwidth=0,marginheight=0,scrollbars=no,scrolling=no,menubar=no,resizable=no");

	frm.target = "p_checkDplc";
	frm.action = "<c:url value='/cvpl/checkCvplUserIdDplc.do'/>";
	frm.submit();
}
-->
</script>
</head>
<body style="text-align:center; margin:0 auto; display:inline; padding-top:100px;">	
	   
<form:form commandName="cvplUserVO" name="registerForm">
<!-- 검색조건 유지 -->
<input type="hidden" name="searchCondition" value="<c:out value='${searchVO.searchCondition}'/>"/>
<input type="hidden" name="searchKeyword" value="<c:out value='${searchVO.searchKeyword}'/>"/>
<input type="hidden" name="pageIndex" value="<c:out value='${searchVO.pageIndex}'/>"/>

<!-- Encryption / Decryption --> 
<input type="hidden" name="ihidnum1_decry" value="<c:out value='${cvplUserVO.ihidnum1}'/>" />
<input type="hidden" name="ihidnum2_decry" value="<c:out value='${cvplUserVO.ihidnum2}'/>" />
<input type="hidden" name="userIdCheck" value="0" />
<div id="content_pop">
	<!-- 타이틀 -->
	<div id="title">
		<ul>
			<li><img src="<c:url value='/images/egovframework/rte/title_dot.gif'/>"> <spring:message code='button.addUser'/></li>
		</ul>
	</div>
	<!-- // 타이틀 -->
	<div id="table">
	  <table width="100%" border="1" cellpadding="0" cellspacing="0" bordercolor="#D3E2EC" bordercolordark="#FFFFFF" style="BORDER-TOP:#C2D0DB 2px solid; BORDER-LEFT:#ffffff 1px solid; BORDER-RIGHT:#ffffff 1px solid; BORDER-BOTTOM:#C2D0DB 1px solid; border-collapse: collapse;">
		<colgroup>
			<col width="150">
			<col width="">
		</colgroup>
		<tr>
			<td class="tbtd_caption"><spring:message code="cvplUserVO.userId"/></td>
			<td class="tbtd_content">
				<form:input path="userId" cssClass="essentiality" maxlength="10" readonly="true"/>
				&nbsp;<form:errors path="userId" />
				<a href="javascript:fn_egov_check_userid();" id="btnCheckDplc"> 
					<img src="<c:url value='/images/egovframework/rte/'/><spring:message code='image.idCheck' />" border="0" class="top"></a></td>
		  </tr>
		  <tr>
			<td class="tbtd_caption"><spring:message code="cvplUserVO.password"/></td>
			<td class="tbtd_content"><form:password path="password" cssClass="txt" maxlength="50" showPassword="true"/>
				&nbsp;<form:errors path="password" /></td>
		  </tr>
		  <tr>
			<td class="tbtd_caption"><spring:message code="cvplUserVO.passwordCnfirm"/></td>
			<td class="tbtd_content"><form:password path="passwordCnfirm" maxlength="50" cssClass="txt"/>
							 &nbsp;<form:errors path="passwordCnfirm" /></td>
			</tr>
		  <tr>
			<td class="tbtd_caption"><spring:message code="cvplUserVO.userName"/></td>
			<td class="tbtd_content"><form:input path="userName" maxlength="10" cssClass="txt"/>
							 &nbsp;<form:errors path="userName" /></td>
		  </tr>
		  <tr>
			<td class="tbtd_caption"><spring:message code="cvplUserVO.ihidnum"/></td>
			<td class="tbtd_content"><form:input path="ihidnum1" maxlength="6" cssClass="txt" /> - <form:password path="ihidnum2" maxlength="7" showPassword="true" cssClass="txt"/>
							 &nbsp;<br><br><form:hidden path="ihidnum" /><form:errors path="ihidnum" /></td>
		  </tr>
		  <tr>
			<td class="tbtd_caption"><spring:message code="cvplUserVO.address"/></td>
			<td class="tbtd_content"><form:input path="address" size="70" maxlength="100" cssClass="txt"/></td>
		  </tr>
		  <tr>
			<td class="tbtd_caption"><spring:message code="cvplUserVO.email"/></td>
			<td class="tbtd_content"><form:input path="email" size="43" maxlength="25" cssClass="txt"/>
									 &nbsp;<br><br><form:errors path="email" /></td>
		  </tr>
		  <tr>
			<td class="tbtd_caption"><spring:message code="cvplUserVO.dept"/></td>
			<td class="tbtd_content">
				<form:select path="deptCode">
					<form:options items="${userDeptCode}" itemValue="code" itemLabel="label" />
				</form:select>
			</td>
		  </tr>
		  <tr>
			<td class="tbtd_caption"><spring:message code="cvplUserVO.rspofc"/></td>
			<td class="tbtd_content">
				<form:select path="rspofcCode" cssClass="use">
					<form:options items="${userRspofcCode}" itemValue="code" itemLabel="label" />
				</form:select>
			</td>
		  </tr>
		</table>
	</div>
	<div id="sysbtn">
		<ul>
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_save_cvpluser();"><spring:message code='button.register'/></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_reset_cvpluser();"><spring:message code="button.reset"/></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_cancel_cvpluser();"><spring:message code="button.cancel"/></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		</ul>
	</div>
</div>
</form:form>

<script language="JavaScript">
document.getElementById("btnCheckDplc").focus();
</script>	
</body>
</html>

