<%@ page contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%
 /**
  * Class Name : EgovCvplUserMyView.jsp
  * Description : Civil Appeal Sample 나의정보 상세 화면
  * Modification Information
  * 
  *   수정일         수정자                   수정내용
  *  -------    --------    ---------------------------
  *  2009.02.01   박소윤         최초 생성
  *
  * author 실행환경 개발팀 박소윤
  * since 2009.02.01
  *  
  * Copyright (C) 2009 by MOPAS  All right reserved.
  */
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="<c:url value='/css/egovframework/egovCvpl.css'/>"/>
<title><spring:message code="pageTitle.egovCvplUserMyView" /></title>

<script type="text/javaScript" language="javascript" defer="defer" src="<c:url value='/js/egovframework/rte/cvpl/cvpluser_cmmn.js'/>"></script>
<script type="text/javaScript" language="javascript" defer="defer">
<!--

function fn_egov_view_cvpluser() {
	frm = document.registerForm;
    frm.action = "<c:url value='/cvpl/updateCvplUserMyView.do'/>";
    frm.submit();
}

-->
</script>
</head>
<body>
<!-- Top -->
<jsp:include page="/cvpl/egovCvplTop.do"/>
<!-- //Top -->
<!-- Left -->
<jsp:include page="/cvpl/egovCvplLeft.do"/>
<!-- //Left -->
<!-- Center -->
<form:form commandName="cvplUserVO" name="registerForm">
<!-- 검색조건 유지 -->
<input type="hidden" name="searchCondition" value="<c:out value='${searchVO.searchCondition}'/>"/>
<input type="hidden" name="searchKeyword" value="<c:out value='${searchVO.searchKeyword}'/>"/>
<input type="hidden" name="pageIndex" value="<c:out value='${searchVO.pageIndex}'/>"/>

<input type="hidden" name="selectedId" value="<c:out value='${cvplUserVO.userId}'/>" />

<div id="content">
	<!-- 타이틀 -->
	<div id="title">
		<ul>
			<li><img src="<c:url value='/images/egovframework/rte/title_dot.gif'/>"> <spring:message code='pageTitle.egovCvplUserMyView'/></li>
		</ul>
	</div>
	<!-- // 타이틀 -->   
	<div id="table">
		<table width="100%" border="1" cellpadding="0" cellspacing="0" bordercolor="#D3E2EC" bordercolordark="#FFFFFF" style="BORDER-TOP:#C2D0DB 2px solid; BORDER-LEFT:#ffffff 1px solid; BORDER-RIGHT:#ffffff 1px solid; BORDER-BOTTOM:#C2D0DB 1px solid; border-collapse: collapse;">
			<colgroup>
					<col width="150">
					<col width="">
			</colgroup>
			<tr>
				<td class="tbtd_caption"><spring:message code="cvplUserVO.userId"/></td>
				<td class="tbtd_content"><c:out value='${cvplUserVO.userId}'/></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code="cvplUserVO.userName"/></td>
				<td class="tbtd_content"><c:out value='${cvplUserVO.userName}'/></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code="cvplUserVO.ihidnum"/></td>
				<td class="tbtd_content"><c:out value='${cvplUserVO.ihidnum1}'/> - <c:out value='${cvplUserVO.ihidnum2}'/></td>
				</tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code="cvplUserVO.address"/></td>
				<td class="tbtd_content"><c:out value='${cvplUserVO.address}'/></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code="cvplUserVO.email"/></td>
				<td class="tbtd_content"><c:out value='${cvplUserVO.email}'/></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code="cvplUserVO.dept"/></td>
				<td class="tbtd_content"><c:out value='${cvplUserVO.deptNm}'/></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code="cvplUserVO.rspofc"/></td>
				<td class="tbtd_content"><c:out value='${cvplUserVO.rspofcNm}'/></td>
			  </tr>
		</table>
	</div>
	<div id="sysbtn">
		<ul>
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_view_cvpluser();"><spring:message code='button.update'/></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		</ul>
	</div>
</div>
</form:form>
<!-- /Center -->
<!-- Bottom -->
<jsp:include page="/cvpl/EgovCvplBottom.do"/>
<!-- //Bottom -->
</body>
</html>