package egovframework.rte.cvpl.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;

import egovframework.rte.fdl.security.userdetails.EgovUserDetails;
import egovframework.rte.fdl.security.userdetails.jdbc.EgovUsersByUsernameMapping;
import egovframework.rte.fdl.security.userdetails.util.EgovUserDetailsHelper;

/**
 * @Class Name : EgovCvplSessionMapping.java
 * @Description : 사용자 SessionMapping class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.02.01 박소윤 최초 생성
 * 
 * @author 실행환경 개발팀 박소윤
 * @since 2009.02.01
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */
public class EgovCvplSessionMapping extends EgovUsersByUsernameMapping {

    public EgovCvplSessionMapping(DataSource ds, String usersByUsernameQuery) {
        super(ds, usersByUsernameQuery);
    }

    @Override
    protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
        logger.debug("## EgovUsersByUsernameMapping mapRow ##");

        String userId = rs.getString("user_id");
        String userName = rs.getString("user_name");
        String deptCode = rs.getString("dept_code");
        String rspofcCode = rs.getString("rspofc_code");
        String password = rs.getString("password");
        boolean enabled = rs.getBoolean("enabled");

        EgovCvplSessionAuth cvplSessionAuth = new EgovCvplSessionAuth();
        cvplSessionAuth.setUserId(userId);
        cvplSessionAuth.setUserName(userName);
        cvplSessionAuth.setDeptCode(deptCode);
        cvplSessionAuth.setRspofcCode(rspofcCode);

        logger.debug("###### cvplSessionVO is " + cvplSessionAuth);

        return new EgovUserDetails(userId, password, enabled, cvplSessionAuth);
    }

}
