package egovframework.rte.cvpl.service;

import java.util.List;

/**
 * @Class Name : EgovCvplCnsltService.java
 * @Description : EgovCvplCnslt Business class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.03.05 천종덕 최초 생성
 * 
 * @author 실행환경 개발팀 천종덕
 * @since 2009.03.05
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */
public interface EgovCvplCnsltService {

    /**
     * 글을 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplCnsltVO
     * @return 등록 결과
     * @exception Exception
     */
    String insertCvplCnslt(CvplCnsltVO vo) throws Exception;

    /**
     * 답변을 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplCnsltVO
     * @return 등록 결과
     * @exception Exception
     */
    void insertAnswerCvplCnslt(CvplCnsltVO vo) throws Exception;

    /**
     * 글을 수정한다.
     * 
     * @param vo
     *            - 수정할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    void updateCvplCnslt(CvplCnsltVO vo) throws Exception;

    /**
     * 답변을 수정한다.
     * 
     * @param vo
     *            - 수정할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    void updateAnswerCvplCnslt(CvplCnsltVO vo) throws Exception;

    /**
     * 글을 삭제한다.
     * 
     * @param vo
     *            - 삭제할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    void deleteCvplCnslt(CvplCnsltVO vo) throws Exception;

    /**
     * 답변을 삭제한다.
     * 
     * @param vo
     *            - 삭제할 정보가 담긴 CvplCnsltVO
     * @return void형
     * @exception Exception
     */
    void deleteAnswerCvplCnslt(CvplCnsltVO vo) throws Exception;

    /**
     * 글을 조회한다.
     * 
     * @param vo
     *            - 조회할 정보가 담긴 CvplCnsltVO
     * @return 조회한 글
     * @exception Exception
     */
    CvplCnsltVO selectCvplCnslt(CvplCnsltVO vo) throws Exception;

    /**
     * 글 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    List selectCvplCnsltList(CvplSearchVO searchVO) throws Exception;

    /**
     * 글 총 갯수를 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 총 갯수
     * @exception
     */
    int selectCvplCnsltListTotCnt(CvplSearchVO searchVO) throws Exception;

    /**
     * 검색어의 자동완성기능을 구현한다.
     * 
     * @param srchPrefix
     *            - 자동완성기능을 사용할 문자
     * @return 검색어리스트
     * @exception Exception
     */
    List<String> selectSearchKeywordList(String srchPrefix) throws Exception;

    /**
     * 검색어의 중복을 체크한다.
     * 
     * @param dupSrchKeyword
     *            - 중복을 체크할 검색어
     * @return searchKeyword
     * @exception Exception
     */
    String checkDupSearchKeywordList(String dupSrchKeyword) throws Exception;

    /**
     * 검색어를 등록한다.
     * 
     * @param searchKeyword
     *            - 등록할 검색어
     * @return searchKeyword
     * @exception Exception
     */
    void insertSearchKeywordList(String searchKeyword) throws Exception;

    /**
     * 엑셀파일 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    List excelDownCvplCnsltList(CvplSearchVO searchVO) throws Exception;

    /**
     * 메일송신 목록을 조회한다.
     * 
     * @param
     * @return 메일송신 목록
     * @exception Exception
     */
    List selectCvplEmail() throws Exception;

    /**
     * 메일송신 완료를 셋팅한다.
     * 
     * @param vo
     *            - 셋팅할 정보가 담긴 CvplEmailVO
     * @return void형
     * @exception Exception
     */

    void updateCvplEmailSend(CvplEmailVO vo) throws Exception;

    /**
     * 나의민원 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 나의민원 목록
     * @exception Exception
     */
    List selectCvplCnsltMyList(CvplSearchVO searchVO) throws Exception;

    /**
     * 나의민원 엑셀파일 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 나의민원 목록
     * @exception Exception
     */
    List excelDownCvplCnsltMyList(CvplSearchVO searchVO) throws Exception;

    /**
     * BEST 민원으로 셋팅한다.
     * 
     * @param vo
     *            - 셋팅할 정보가 담긴 CvplCnsltVO vo
     * @return void형
     * @exception Exception
     */
    void updateCvplCnsltBest(CvplCnsltVO vo) throws Exception;

    /**
     * BEST 민원을 등록한다.
     * 
     * @param vo
     *            - 등록할 정보가 담긴 CvplCnsltVO vo
     * @return void형
     * @exception Exception
     */
    void insertBestCvplCnslt(CvplCnsltVO vo) throws Exception;

}
