package egovframework.rte.cvpl.service;

import java.util.List;

/**
 * @Class Name : EgovCvplUserService.java
 * @Description : 사용자 Business class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.02.01 박소윤 최초 생성
 * 
 * @author 실행환경 개발팀 박소윤
 * @since 2009.02.01
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */
public interface EgovCvplUserService {

    /**
     * 사용자 가입
     * 
     * @param vo
     *            - 사용자 가입할 정보가 담긴 CvplUserVO
     * @return 등록 결과
     * @exception Exception
     */
    String insertCvplUser(CvplUserVO vo) throws Exception;

    /**
     * 사용자 수정
     * 
     * @param vo
     *            - 사용자 수정할 정보가 담긴 CvplUserVO
     * @return void형
     * @exception Exception
     */
    void updateCvplUser(CvplUserVO vo) throws Exception;

    /**
     * 사용자 삭제
     * 
     * @param vo
     *            - 삭제할 정보가 담긴 CvplUserVO
     * @return void형
     * @exception Exception
     */
    void deleteCvplUser(CvplUserVO vo) throws Exception;

    /**
     * 사용자를 조회한다.
     * 
     * @param vo
     *            - 조회할 정보가 담긴 CvplUserVO
     * @return 조회한 글
     * @exception Exception
     */
    CvplUserVO selectCvplUser(CvplUserVO vo) throws Exception;

    /**
     * 사용자 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 사용자 목록
     * @exception Exception
     */
    List selectCvplUserList(CvplSearchVO searchVO) throws Exception;

    /**
     * 사용자 총 갯수를 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 사용자 총 갯수
     * @exception
     */
    int selectCvplUserListTotCnt(CvplSearchVO searchVO);

    /**
     * check for duplicate user id.
     * 
     * @param vo
     *            - 검색할 사용자 아이디가 담긴 VO
     * @return 사용 가능한 아이디 일 경우 <code>true</code> 사용 중인 아이디 일 경우
     *         <code>false</code>
     * @exception Exception
     */
    boolean checkCvplUserIdDplc(CvplUserVO cvplUserVO) throws Exception;

    /**
     * 엑셀파일 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    List excelDownCvplUserList(CvplSearchVO searchVO) throws Exception;

}
