package egovframework.rte.cvpl.service.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import egovframework.rte.cvpl.service.CvplSearchVO;
import egovframework.rte.cvpl.service.CvplUserVO;
import egovframework.rte.psl.dataaccess.EgovAbstractDAO;

/**
 * @Class Name : EgovAbstractDAO.java
 * @Description : EgovAbstract DAO Class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.02.01 홍길동 최초 생성
 * 
 * @author 실행환경 개발팀 홍길동
 * @since 2009.02.01
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */

@Repository("cvplUserDAO")
public class CvplUserDAO extends EgovAbstractDAO {

    /**
     * 사용자 가입
     * 
     * @param vo
     *            - 사용자 가입할 정보가 담긴 CvplUserVO
     * @return 등록 결과
     * @exception Exception
     */
    public String insertCvplUser(CvplUserVO vo) throws Exception {
        return (String) insert("cvplUserDAO.insertCvplUser", vo);
    }

    /**
     * 사용자 가입 권한 등록
     * 
     * @param vo
     *            - 사용자 가입할 정보가 담긴 CvplUserVO
     * @return 등록 결과
     * @exception Exception
     */
    public String insertCvplUserAuth(CvplUserVO vo) throws Exception {
        return (String) insert("cvplUserDAO.insertCvplUserAuth", vo);
    }

    /**
     * 사용자 수정
     * 
     * @param vo
     *            - 사용자 수정할 정보가 담긴 CvplUserVO
     * @return void형
     * @exception Exception
     */
    public void updateCvplUser(CvplUserVO vo) throws Exception {
        update("cvplUserDAO.updateCvplUser", vo);
    }

    /**
     * 사용자 삭제
     * 
     * @param vo
     *            - 삭제할 정보가 담긴 CvplUserVO
     * @return void형
     * @exception Exception
     */
    public void deleteCvplUser(CvplUserVO vo) throws Exception {
        delete("cvplUserDAO.deleteCvplUser", vo);
    }

    /**
     * 사용자 가입 권한 삭제
     * 
     * @param vo
     *            - 삭제할 정보가 담긴 CvplUserVO
     * @return void형
     * @exception Exception
     */
    public void deleteCvplUserAuth(CvplUserVO vo) throws Exception {
        delete("cvplUserDAO.deleteCvplUserAuth", vo);
    }

    /**
     * 사용자를 조회한다.
     * 
     * @param vo
     *            - 조회할 정보가 담긴 CvplUserVO
     * @return 조회한 글
     * @exception Exception
     */
    public CvplUserVO selectCvplUser(CvplUserVO vo) throws Exception {
        return (CvplUserVO) selectByPk("cvplUserDAO.selectCvplUser", vo);
    }

    /**
     * 사용자 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 사용자 목록
     * @exception Exception
     */
    public List selectCvplUserList(CvplSearchVO searchVO) throws Exception {
        return list("cvplUserDAO.selectCvplUserList", searchVO);
    }

    /**
     * 사용자 총 갯수를 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 사용자 총 갯수
     * @exception
     */
    public int selectCvplUserListTotCnt(CvplSearchVO searchVO) {

        return Integer.parseInt(getSqlMapClientTemplate().queryForObject("cvplUserDAO.selectCvplUserListTotCnt",
                                                                         searchVO).toString());
    }

    /**
     * check for duplicate user id.
     * 
     * @param vo
     *            - 검색할 사용자 아이디가 담긴 VO
     * @return 사용 가능한 아이디 일 경우 <code>true</code> 사용 중인 아이디 일 경우
     *         <code>false</code>
     * @exception Exception
     */
    public int checkCvplUserIdDplc(CvplUserVO cvplUserVO) throws Exception {

        return Integer.parseInt(getSqlMapClientTemplate().queryForObject("cvplUserDAO.checkCvplUserIdDplc", cvplUserVO)
                                                         .toString());
    }

    /**
     * 엑셀파일 목록을 조회한다.
     * 
     * @param searchVO
     *            - 조회할 정보가 담긴 VO
     * @return 글 목록
     * @exception Exception
     */
    public List excelDownCvplUserList(CvplSearchVO searchVO) throws Exception {
        return list("cvplUserDAO.excelDownCvplUserList", searchVO);
    }

}
