package egovframework.rte.cvpl.util;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

import egovframework.rte.cvpl.service.CvplCnsltVO;
import egovframework.rte.cvpl.service.CvplEmailVO;
import egovframework.rte.cvpl.service.EgovCvplCnsltService;
import egovframework.rte.cvpl.util.EgovCvplCnsltMailService;

/**
 * @Class Name : EgovCvplCnsltSchedulingService.java
 * @Description : EgovCvplCnsltSchedulingService class
 * @Modification Information @ @ 수정일 수정자 수정내용 @ ------- --------
 *               --------------------------- @ 2009.03.05 천종덕 최초 생성
 * 
 * @author 실행환경 개발팀 천종덕
 * @since 2009.03.05
 * @version 1.0
 * @see Copyright (C) 2009 by MOPAS All right reserved.
 */
@Service("egovCvplCnsltSchedulingService")
public class EgovCvplCnsltSchedulingService {

    /** EgovCvplCnsltService */
    @Resource(name = "cvplCnsltService")
    private EgovCvplCnsltService cvplCnsltService;

    /** EgovCvplCnsltMailService */
    @Resource(name = "egovCvplCnsltMailService")
    private EgovCvplCnsltMailService egovCvplCnsltMailService;

    /**
     * email을 보낼 대상을 선정한다.
     * 
     * @param
     * @return EgovCvplCnsltMailService
     * @exception Exception
     */
    public void sendAnswerEmail() throws Exception {
        CvplEmailVO cvplEmailVO = new CvplEmailVO();
        String sResult = "";
        List<CvplEmailVO> cvplEmailVOList = cvplCnsltService.selectCvplEmail();

        for (int i = 0; i < cvplEmailVOList.size(); i++) {
            cvplEmailVO = (CvplEmailVO) cvplEmailVOList.get(i);

            egovCvplCnsltMailService.setEmailName(cvplEmailVO.getEmailName());
            egovCvplCnsltMailService.setEmailAddr(cvplEmailVO.getEmailAddr());
            egovCvplCnsltMailService.setEmailSj(cvplEmailVO.getEmailSj());
            egovCvplCnsltMailService.setEmailContents(cvplEmailVO.getEmailContents());

            sResult = egovCvplCnsltMailService.sendEmail();

            // 메일송신이 성공했을 경우에만 메일송신 완료 셋팅을 해준다.
            if (sResult.equals("SUCCESS")) {
                cvplCnsltService.updateCvplEmailSend(cvplEmailVO);
            }

        }

    }

}
