<%@ page contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="validator" uri="http://www.springmodules.org/tags/commons-validator" %>
<%
 /**
  * @Class Name : egovCvplFaqRegister.java
  * @Description : CvplFaq Register 화면
  * @Modification Information
  * @
  * @  수정일         수정자                   수정내용
  * @ -------    --------    ---------------------------
  * @ 2009.03.05    천종덕          최초 생성
  *
  *  @author 실행환경 개발팀 천종덕
  *  @since 2009.03.05
  *  @version 1.0
  *  @see
  *  
  *  Copyright (C) 2009 by MOPAS  All right reserved.
  */
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="<c:url value='/css/egovframework/egovCvpl.css'/>"/>
<title><spring:message code="pageTitle.egovCvplFaqRegister" /> <c:out value="${registerFlag}"/> </title>
<!--For Commons Validator Client Side-->
<script type="text/javascript" src="<c:url value="/cmmn/validator.js"/>"></script>
<validator:javascript formName="cvplFaqVO" staticJavascript="false" xhtml="true" cdata="false"/>

<script type="text/javascript" src="<c:url value='/js/egovframework/rte/cvpl/multifile.js'/>"></script>
<script type="text/javaScript" language="javascript" defer="defer">
<!--
var multi_selector = new MultiSelector( document.getElementById( 'cvplFileList' ), 2 );
multi_selector.addElement( document.getElementById( 'cvplFileUploader' ) );

function fn_egov_list_cvplfaq() {
	document.registerForm.action = "<c:url value='/cvpl/egovCvplFaqList.do'/>";
	document.registerForm.submit();		
}

function fn_egov_add_cvplfaq() {
	if(!validateCvplFaqVO(document.registerForm)){
        return;
    }else{
    	document.registerForm.action = "<c:url value='/cvpl/addCvplFaq.do'/>";
    	document.registerForm.submit();		
    }
}

function fn_egov_cancel_cvplfaq() {
	document.registerForm.reset();
}

-->
</script>
</head>
<body>
<!-- Top -->
<jsp:include page="/cvpl/egovCvplTop.do"/>
<!-- //Top -->
<!-- Left -->
<jsp:include page="/cvpl/egovCvplLeft.do"/>
<!-- //Left -->
<!-- Center -->
<div id="content">
	<!-- 타이틀 -->
	<div id="title">
		<ul>
			<li><img src="<c:url value='/images/egovframework/rte/title_dot.gif'/>"> <spring:message code='pageTitle.egovCvplFaqRegister'/></li>
		</ul>
	</div>
	<!-- // 타이틀 -->
	<form:form commandName="cvplFaqVO" name="registerForm" enctype="multipart/form-data" method="post">
	<div id="table">
		  <table width="100%" border="1" cellpadding="0" cellspacing="0" bordercolor="#D3E2EC" bordercolordark="#FFFFFF" style="BORDER-TOP:#C2D0DB 2px solid; BORDER-LEFT:#ffffff 1px solid; BORDER-RIGHT:#ffffff 1px solid; BORDER-BOTTOM:#C2D0DB 1px solid; border-collapse: collapse;">
			  <colgroup>
				<col width="150">
				<col width="">
			  </colgroup>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.user' /></td>
				<td class="tbtd_content"><form:input path="userName" cssClass="txt" readonly="readonly" /></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.faqSj' /></td>
				<td class="tbtd_content"><form:input path="faqSj" cssClass="txt" />&nbsp;<form:errors path="faqSj" /></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.faqContents' /></td>
				<td class="tbtd_content"><form:textarea path="faqContents" rows="5" cols="58" /></td>
				</tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.faqAtch1' /></td>
				<td class="tbtd_content"><input name="file_1" id="cvplFileUploader" type="file" size="60" class="txt"/></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.faqAtch2' /></td>
				<td class="tbtd_content"><div id="cvplFileList"></div></td>
			  </tr>
		   </table>
	  </div>
	  <div id="sysbtn">
		  <ul>
		  <li><span class="btn_blue_l"><a href="javascript:fn_egov_list_cvplfaq();"><spring:message code='button.list' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		  <c:if test="${(egovCvplSessionAuth.isAdmin || egovCvplSessionAuth.isEgov)}">
		  <li><span class="btn_blue_l"><a href="javascript:fn_egov_add_cvplfaq();"><spring:message code='button.register' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		  </c:if>
		  <li><span class="btn_blue_l"><a href="javascript:fn_egov_cancel_cvplfaq();"><spring:message code='button.reset' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li></ul>
	  </div>
	<!-- 검색조건 유지 -->
	<input type="hidden" name="searchCondition" value="<c:out value='${searchVO.searchCondition}'/>"/>
	<input type="hidden" name="searchKeyword" value="<c:out value='${searchVO.searchKeyword}'/>"/>
	<input type="hidden" name="pageIndex" value="<c:out value='${searchVO.pageIndex}'/>"/>
	</form:form>
</div>
<!-- /Center -->
<!-- Bottom -->
<jsp:include page="/cvpl/EgovCvplBottom.do"/>
<!-- //Bottom -->
</body>
</html>