<%@ page contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="validator" uri="http://www.springmodules.org/tags/commons-validator" %>
<%
 /**
  * @Class Name : egovCvplFaqUpdate.java
  * @Description : CvplFaq Update 화면
  * @Modification Information
  * @
  * @  수정일         수정자                   수정내용
  * @ -------    --------    ---------------------------
  * @ 2009.03.05    천종덕          최초 생성
  *
  *  @author 실행환경 개발팀 천종덕
  *  @since 2009.03.05
  *  @version 1.0
  *  @see
  *  
  *  Copyright (C) 2009 by MOPAS  All right reserved.
  */
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="<c:url value='/css/egovframework/egovCvpl.css'/>"/>
<title><spring:message code="pageTitle.egovCvplFaqUpdate" /></title>
<!--For Commons Validator Client Side-->
<script type="text/javascript" src="<c:url value="/cmmn/validator.js"/>"></script>
<validator:javascript formName="cvplFaqVO" staticJavascript="false" xhtml="true" cdata="false"/>

<script type="text/javascript" src="<c:url value='/js/egovframework/rte/cvpl/multifile.js'/>"></script>
<script type="text/javaScript" language="javascript" defer="defer">
<!--
var multi_selector = new MultiSelector( document.getElementById( 'cvplFileList' ), 2 );
multi_selector.addElement( document.getElementById( 'cvplFileUploader' ) );

function fn_egov_list_cvplfaq() {
   	document.updateForm.action = "<c:url value='/cvpl/egovCvplFaqList.do'/>";
   	document.updateForm.submit();		
}

function fn_egov_delete_cvplfaq() {
   	document.updateForm.action = "<c:url value='/cvpl/deleteCvplFaq.do'/>";
   	document.updateForm.submit();		
}

function fn_egov_save_cvplfaq() {
	if(!validateCvplFaqVO(document.updateForm)){
        return;
    }else{
       	document.updateForm.action = "<c:url value='/cvpl/updateCvplFaq.do'/>";
       	document.updateForm.submit();		
    }
}

function fn_egov_cancel_cvplfaq() {
	document.updateForm.reset();
}

function fn_egov_check_file() {
	if(document.updateForm.fileCheck.checked) {
		document.updateForm.fileYN.value = "Y";
		document.getElementById('divFileYN_Y').style.display = "block";
		document.getElementById('divFileYN_N').style.display = "none";
	} else {
		document.updateForm.fileYN.value = "N";
		document.getElementById('divFileYN_Y').style.display = "none";
		document.getElementById('divFileYN_N').style.display = "block";
	}
}

function fn_egov_download_file(reqfile) {
	window.open(encodeURI("<c:url value='/cvpl/egovDownloadFile.do?'/>requestedFile=") + reqfile);
}

-->
</script>
</head>
<body>
<!-- Top -->
<jsp:include page="/cvpl/egovCvplTop.do"/>
<!-- //Top -->
<!-- Left -->
<jsp:include page="/cvpl/egovCvplLeft.do"/>
<!-- //Left -->
<!-- Center -->
<div id="content">
	<!-- 타이틀 -->
	<div id="title">
		<ul>
			<li><img src="<c:url value='/images/egovframework/rte/title_dot.gif'/>"> <spring:message code='pageTitle.egovCvplFaqUpdate'/></li>
		</ul>
	</div>
	<!-- // 타이틀 -->
	<form:form commandName="cvplFaqVO" name="updateForm" enctype="multipart/form-data" method="post">
    <form:hidden path="faqNo" />
    <input name="fileYN" id="fileYN" type="hidden" value="N"/>

	<div id="table">
		  <table width="100%" border="1" cellpadding="0" cellspacing="0" bordercolor="#D3E2EC" bordercolordark="#FFFFFF" style="BORDER-TOP:#C2D0DB 2px solid; BORDER-LEFT:#ffffff 1px solid; BORDER-RIGHT:#ffffff 1px solid; BORDER-BOTTOM:#C2D0DB 1px solid; border-collapse: collapse;">
			<colgroup>
					<col width="150">
					<col width="">
			</colgroup>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.user' /></td>
				<td class="tbtd_content"><form:input path="userName" cssClass="txt" readonly="readonly" /></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.registTime' /></td>
				<td class="tbtd_content"><c:out value='${cvplFaqVO.registTime}'/></td>
				</tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.faqSj' /></td>
				<td class="tbtd_content"><form:input path="faqSj" cssClass="txt" />&nbsp;<form:errors path="faqSj" /></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.faqContents' /></td>
				<td class="tbtd_content"><form:textarea path="faqContents" rows="5" cols="58" /></td>
			  </tr>
			  <tr>
				<td class="tbtd_caption"><spring:message code='title.faq.faqAtchYN' /></td>
				<td class="tbtd_content"><input type="checkbox" id="fileCheck" onclick="javascript:fn_egov_check_file();"/></td>
			  </tr>
			  <tr>
				<td colspan="2" height="5"></td>
				</tr>
			  <tr>
		</table>
		<div id="divFileYN_Y" style="display:none;">
			 <table width="100%" border="1" cellpadding="0" cellspacing="0" bordercolor="#D3E2EC" bordercolordark="#FFFFFF" style="BORDER-TOP:#C2D0DB 2px solid; BORDER-LEFT:#ffffff 1px solid; BORDER-RIGHT:#ffffff 1px solid; BORDER-BOTTOM:#C2D0DB 1px solid; border-collapse: collapse;">
				<colgroup>
						<col width="150">
						<col width="">
				</colgroup>
				  <tr>
					<td class="tbtd_caption"><spring:message code='title.faq.faqAtch1' /></td>
					<td class="tbtd_content"><input name="file_1" id="cvplFileUploader" type="file" size="60" /></td>
				  </tr>
				  <tr>
					<td class="tbtd_caption"><spring:message code='title.faq.faqAtch2' /></td>
					<td class="tbtd_content"><div id="cvplFileList"></div></td>
				  </tr>
			  </table>
		 </div>
		 <div id="divFileYN_N">
			 <table width="100%" border="1" cellpadding="0" cellspacing="0" bordercolor="#D3E2EC" bordercolordark="#FFFFFF" style="BORDER-TOP:#C2D0DB 2px solid; BORDER-LEFT:#ffffff 1px solid; BORDER-RIGHT:#ffffff 1px solid; BORDER-BOTTOM:#C2D0DB 1px solid; border-collapse: collapse;">
				<colgroup>
						<col width="150">
						<col width="">
				</colgroup>
				  <tr>
					<td class="tbtd_caption"><spring:message code='title.faq.faqAtch1' /></td>
					<td class="tbtd_content">
						<c:if test="${cvplFaqVO.faqAtch1 != '' && cvplFaqVO.faqAtch1 != null}">
		        			<c:out value='${cvplFaqVO.faqAtch1}'/>
							<a href="javascript:fn_egov_download_file('<c:out value="${cvplFaqVO.faqAtch1}"/>')"><img src="<c:url value='/images/egovframework/rte/btn_form_down.gif'/>" border="0" class="top"></a>
						</c:if>
						<c:if test="${cvplFaqVO.faqAtch2 != '' && cvplFaqVO.faqAtch2 != null}">
			            	<br/><c:out value='${cvplFaqVO.faqAtch2}'/>
							<a href="javascript:fn_egov_download_file('<c:out value="${cvplFaqVO.faqAtch2}"/>')"><img src="<c:url value='/images/egovframework/rte/btn_form_down.gif'/>" border="0" class="top"></a>
						</c:if>
					</td>
				  </tr>
			  </table>
		 </div>
	</div>
	<div id="sysbtn">
		<ul>
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_list_cvplfaq();"><spring:message code='button.list' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		<c:if test="${cvplFaqVO.userId  == egovCvplSessionAuth.userId && (egovCvplSessionAuth.isAdmin || egovCvplSessionAuth.isEgov)}">
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_save_cvplfaq();"><spring:message code='button.update' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_delete_cvplfaq();"><spring:message code='button.delete' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
		</c:if>
		<li><span class="btn_blue_l"><a href="javascript:fn_egov_cancel_cvplfaq();"><spring:message code='button.reset' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li></ul>
	</div>
	<!-- 검색조건 유지 -->
	<input type="hidden" name="searchCondition" value="<c:out value='${searchVO.searchCondition}'/>"/>
	<input type="hidden" name="searchKeyword" value="<c:out value='${searchVO.searchKeyword}'/>"/>
	<input type="hidden" name="pageIndex" value="<c:out value='${searchVO.pageIndex}'/>"/>
	</form:form>
</div>
<!-- /Center -->
<!-- Bottom -->
<jsp:include page="/cvpl/EgovCvplBottom.do"/>
<!-- //Bottom -->
</body>
</html>

