package egovframework.rte.cvpl.util;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Repository;

import egovframework.rte.cvpl.service.CvplFaqVO;
import egovframework.rte.cvpl.service.EgovCvplFaqService;
import egovframework.rte.cvpl.service.impl.CvplFaqDAO;
import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationServiceProvider;

@Repository("serviceProviderRegisterFaq")
public class ServiceProviderRegisterFaq implements EgovIntegrationServiceProvider {

    /** EgovCvplFaqService */
    @Resource(name = "cvplFaqService")
    private EgovCvplFaqService cvplFaqService;

    public void service(EgovIntegrationMessage requestMessage, EgovIntegrationMessage responseMessage) {
        Map<String, Object> requestBody = requestMessage.getBody();

        CvplFaqVO vo = new CvplFaqVO();
        vo.setFaqNo((String) requestBody.get("faqNo"));
        vo.setFaqSj((String) requestBody.get("faqSj"));
        vo.setFaqContents((String) requestBody.get("faqContents"));
        vo.setFaqAtch1((String) requestBody.get("faqAtch1"));
        vo.setFaqAtch2((String) requestBody.get("faqAtch2"));
        vo.setOrgRegistTime((String) requestBody.get("registTime"));
        vo.setUserId((String) requestBody.get("userId"));
        vo.setAdmnstmachCode((String) requestBody.get("admnstmachCode"));
        vo.setBestYn((String) requestBody.get("bestYn"));

        Map<String, Object> responseBody = new HashMap<String, Object>();
        try {
            cvplFaqService.insertBestCvplFaq(vo);
            responseBody.put("result", true);
        } catch (Exception e) {
            responseBody.put("result", false);
        }

        responseMessage.setBody(responseBody);
    }
}
