package egovframework.rte.cvpl.web.view;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.servlet.view.document.AbstractExcelView;
import egovframework.rte.cvpl.service.CvplFaqVO;

/**
 * @Class Name : CvplFaqExcelView.java
 * @Description : CvplFaqExcelView class
 * @Modification Information
 * @
 * @  수정일         수정자                   수정내용
 * @ -------    --------    ---------------------------
 * @ 2009.03.05    천종덕          최초 생성
 *
 *  @author 실행환경 개발팀 천종덕
 *  @since 2009.03.05
 *  @version 1.0
 *  @see
 *  
 *  Copyright (C) 2009 by MOPAS  All right reserved.
 */
public class CvplFaqExcelView extends AbstractExcelView {

	/**
	 * 엑셀파일을 만들어 다운로드한다.
	 * @param model - 생성할 정보가 담긴 Map
	 * @return "엑셀파일 다운로드"
	 * @exception Exception
	 */                 
	@Override
	protected void buildExcelDocument(Map model, HSSFWorkbook wb,
            HttpServletRequest req, HttpServletResponse resp) throws Exception {
        HSSFCell cell = null;
        int idx = 0;

        HSSFSheet sheet = wb.createSheet("FAQ목록");
        //sheet.setDefaultColumnWidth((short) 12);

        // put text in first cell
        cell = getCell(sheet, 0, 0);
        setText(cell, "FAQ목록");

        // set header information
        idx = 0;
        setText(getCell(sheet, 2, idx++), "번호");
        setText(getCell(sheet, 2, idx++), "제목");
        setText(getCell(sheet, 2, idx++), "내용");
        setText(getCell(sheet, 2, idx++), "첨부파일1");
        setText(getCell(sheet, 2, idx++), "첨부파일2");
        setText(getCell(sheet, 2, idx++), "등록시간");
        setText(getCell(sheet, 2, idx++), "등록자번호");
        setText(getCell(sheet, 2, idx++), "등록자ID");
        setText(getCell(sheet, 2, idx++), "등록자이름");
        setText(getCell(sheet, 2, idx++), "등록자부서");
        setText(getCell(sheet, 2, idx++), "등록자부서명");
        setText(getCell(sheet, 2, idx++), "등록자직책");
        setText(getCell(sheet, 2, idx++), "등록자직책명");
        setText(getCell(sheet, 2, idx++), "행정기관코드");
        setText(getCell(sheet, 2, idx++), "행정기관명");
        setText(getCell(sheet, 2, idx++), "Best 채택여부");

        Map<String, Object> map= (Map<String, Object>) model.get("cvplFaqMap");
        List<Object> cvplFaqList = (List<Object>) map.get("cvplFaq");

        for (int i = 0; i < cvplFaqList.size(); i++) {
        	Object obj = cvplFaqList.get(i);
        	CvplFaqVO cvplFaqVO = (CvplFaqVO) obj;
            idx = 0;
    		
            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getFaqNo());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getFaqSj());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getFaqContents());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getFaqAtch1());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getFaqAtch2());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getRegistTime());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getUserId());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getUserName());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getUserDept());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getUserDeptNm());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getUserRspofc());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getUserRspofcNm());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getAdmnstmachCode());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getAdmnstmachCodeNm());

            cell = getCell(sheet, 3 + i, idx++);
            setText(cell, cvplFaqVO.getBestYn());

        }
    }
}
