<%@ page contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="ui" uri="http://egovframework.gov/ctl/ui"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%
 /**
  * Class Name : EgovCvplUserList.jsp
  * Description : Civil Appeal Sample 사용자 List 화면
  * Modification Information
  * 
  *   수정일         수정자                   수정내용
  *  -------    --------    ---------------------------
  *  2009.02.01   박소윤         최초 생성
  *
  * author 실행환경 개발팀 박소윤
  * since 2009.02.01
  *  
  * Copyright (C) 2009 by MOPAS  All right reserved.
  */
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="<c:url value='/css/egovframework/egovCvpl.css'/>"/>
<title><spring:message code="pageTitle.egovCvplUserList" /></title>
<script type="text/javaScript" language="javascript" defer="defer">
<!--
function fn_egov_view_cvpluser(id) {
	document.listForm.selectedId.value = id;
   	document.listForm.action = "<c:url value='/cvpl/selectCvplUserView.do'/>";
   	document.listForm.submit();		
}

function fn_egov_addview_cvpluser() {
   	document.listForm.action = "<c:url value='/cvpl/addCvplUserView.do'/>";
   	document.listForm.submit();		
}

function fn_egov_search_cvpluser() {
	frm = document.listForm;
	frm.action = "<c:url value='/cvpl/egovCvplUserList.do'/>";
	frm.submit();     
}

function fn_egov_download_excel() {
    document.listForm.action = "<c:url value='/cvpl/excelDownCvplUserList.do'/>";
    document.listForm.submit();     
}

function fn_egov_link_page(pageNo){
	document.listForm.pageIndex.value = pageNo;
	document.listForm.action = "<c:url value='/cvpl/egovCvplUserList.do'/>";
   	document.listForm.submit();
}

-->
</script>
</head>
<body>
<!-- Top -->
<jsp:include page="/cvpl/egovCvplTop.do"/>
<!-- //Top -->
<!-- Left -->
<jsp:include page="/cvpl/egovCvplLeft.do"/>
<!-- //Left -->
<!-- Center -->
<div id="content">
	<!-- 타이틀 -->
	<div id="title">
		<ul>
			<li><img src="<c:url value='/images/egovframework/rte/title_dot.gif'/>"> <spring:message code='pageTitle.egovCvplUserList'/></li>
		</ul>
	</div>
	<!-- // 타이틀 -->
	<form:form commandName="searchVO" name="listForm" method="post">
		<div id="search">
			<ul>
			<li>
			<form:select path="searchCondition">
				<form:option value="1"><spring:message code="search.name" /></form:option>
				<form:option value="0"><spring:message code="search.id" /></form:option>
			</form:select>
			</li>
			<li><form:input path="searchKeyword" cssClass="txt"/></li>
			<li><span class="btn_blue_l"><a href="javascript:fn_egov_search_cvpluser();"><spring:message code="button.search" /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li></ul>
		</div>
		<!-- LIST -->
		<input name="selectedId" type="hidden" />
		<div id="table">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<colgroup>
					<col width="40">
					<col width="60">
					<col width="80">
					<col width="">
					<col width="80">
					<col width="60">
				</colgroup>		  
				<tr>
					<th align="center"><spring:message code="title.cvpl.num"/></th>
					<th align="center"><spring:message code="cvplUserVO.userId"/></th>
					<th align="center"><spring:message code="cvplUserVO.userName"/></th>
					<th align="center"><spring:message code="cvplUserVO.email"/></th>
					<th align="center"><spring:message code="cvplUserVO.dept"/></th>
					<th align="center"><spring:message code="cvplUserVO.rspofc"/></th>
				</tr>
				<c:forEach var="result" items="${cvplUserList}" varStatus="status">
				<tr>
					<td align="center" class="listtd"><c:out value="${status.count}"/></td>
					<td align="center" class="listtd"><a href="javascript:fn_egov_view_cvpluser('<c:out value="${result.userId}"/>')"><c:out value="${result.userId}"/></a></td>
					<td align="center" class="listtd"><c:out value="${result.userName}"/></td>
					<td align="left" class="listtd"><c:out value="${result.email}"/>&nbsp;</td>
					<td align="center" class="listtd"><c:out value="${result.deptNm}"/>&nbsp;</td>
					<td align="center" class="listtd"><c:out value="${result.rspofcNm}"/>&nbsp;</td>
				</tr>
				</c:forEach>
			</table>
		</div>
		<div id="paging">
			<ui:pagination paginationInfo = "${paginationInfo}"
					   type="image"
					   jsFunction="fn_egov_link_page"
					   />
			<form:hidden path="pageIndex" />
		</div>
		<div id="sysbtn">
			<ul>
			<li><span class="btn_blue_l"><a href="javascript:fn_egov_download_excel();"><spring:message code='button.excelDown' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li>
			<li><span class="btn_blue_l"><a href="javascript:fn_egov_addview_cvpluser();"><spring:message code='button.register' /></a><img src="<c:url value='/images/egovframework/rte/btn_bg_r.gif'/>" style="margin-left:6px;"></span></li></ul>
		</div>
	</form:form>
</div>
<!-- /Center -->
<!-- Bottom -->
<jsp:include page="/cvpl/EgovCvplBottom.do"/>
<!-- //Bottom -->
</body>
</html>
