/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.compress.CompressException;
import org.apache.commons.compress.Compressor;
import org.apache.commons.compress.PackableObject;
import org.apache.commons.compress.compressors.bzip2.BZip2Compressor;

public abstract class CompressorFactory {
    private final String name;
    private static List compressors = new ArrayList();
    public static CompressorFactory BZIP2;
    static /* synthetic */ Class class$org$apache$commons$compress$compressors$bzip2$BZip2Compressor;
    static /* synthetic */ Class class$org$apache$commons$compress$Compressor;

    public static void registerCompressor(String className) throws ClassNotFoundException, CompressException {
        Class<?> clazz = Class.forName(className);
        CompressorFactory.registerCompressor(clazz);
    }

    public static void registerCompressor(Class clazz) throws CompressException {
        if ((class$org$apache$commons$compress$Compressor == null ? (class$org$apache$commons$compress$Compressor = CompressorFactory.class$("org.apache.commons.compress.Compressor")) : class$org$apache$commons$compress$Compressor).isAssignableFrom(clazz) && !clazz.isInterface()) {
            try {
                compressors.add(clazz.newInstance());
            }
            catch (InstantiationException e) {
                throw new CompressException("Compressor could not be instantiated", e);
            }
            catch (IllegalAccessException e) {
                throw new CompressException("Compressor could not be instantiated", e);
            }
        } else {
            throw new CompressException("Compressor does not implement the Compressor.class interface.");
        }
    }

    private CompressorFactory(String name) {
        this.name = name;
    }

    public abstract Compressor getInstance();

    public static Compressor getInstance(String compressorName) throws CompressException {
        try {
            if (compressorName == null) {
                throw new CompressException("CompressorFactory could not create instance");
            }
            Iterator it = compressors.iterator();
            while (it.hasNext()) {
                PackableObject po = (PackableObject)it.next();
                if (!po.isPackableWith(compressorName, 2)) continue;
                return (Compressor)po.getClass().newInstance();
            }
            return null;
        }
        catch (InstantiationException e) {
            throw new CompressException("CompressorFactory could not create instance", e);
        }
        catch (IllegalAccessException e) {
            throw new CompressException("CompressorFactory could not create instance", e);
        }
    }

    public static Compressor getInstance(File file) throws CompressException {
        if (file == null || !file.isFile()) {
            throw new CompressException("CompressorFactory could not create instance for this file");
        }
        PackableObject packable = null;
        try {
            packable = PackableObject.identifyByHeader(file, compressors);
            if (packable == null) {
                return null;
            }
            Compressor compressor = (Compressor)packable.getClass().newInstance();
            return compressor;
        }
        catch (SecurityException e) {
            throw new CompressException("A security violation occured while reading the field ARCHIVER_NAME", e);
        }
        catch (IllegalArgumentException e) {
            throw new CompressException("Internal factory exception", e);
        }
        catch (Exception e) {
            throw new CompressException("CompressorFactory could not create instance", e);
        }
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            CompressorFactory.registerCompressor(class$org$apache$commons$compress$compressors$bzip2$BZip2Compressor == null ? (class$org$apache$commons$compress$compressors$bzip2$BZip2Compressor = CompressorFactory.class$("org.apache.commons.compress.compressors.bzip2.BZip2Compressor")) : class$org$apache$commons$compress$compressors$bzip2$BZip2Compressor);
        }
        catch (CompressException e) {
            e.printStackTrace();
        }
        BZIP2 = new CompressorFactory("BZIP2"){

            public Compressor getInstance() {
                return new BZip2Compressor();
            }
        };
    }
}

