/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.osgiplugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.plugin.eclipse.osgiplugin.EclipseOsgiPlugin;

public abstract class AbstractEclipseOsgiPlugin
implements EclipseOsgiPlugin {
    private File file;
    private Properties pluginProperties;

    public AbstractEclipseOsgiPlugin(File file) {
        this.setFile(file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.getFile().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties getPluginProperties() throws IOException {
        if (this.pluginProperties != null) return this.pluginProperties;
        JarFile file = this.getJar();
        InputStream pluginPropertiesStream = null;
        try {
            this.pluginProperties = new Properties();
            ZipEntry jarEntry = file.getEntry("plugin.properties");
            if (jarEntry != null) {
                pluginPropertiesStream = file.getInputStream(jarEntry);
                this.pluginProperties.load(pluginPropertiesStream);
            }
            Object var5_4 = null;
            if (pluginPropertiesStream == null) return this.pluginProperties;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (pluginPropertiesStream == null) throw throwable;
            try {
                pluginPropertiesStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            pluginPropertiesStream.close();
            return this.pluginProperties;
        }
        catch (IOException e) {}
        return this.pluginProperties;
    }

    public Properties getPomProperties() {
        return new Properties();
    }

    public String getManifestAttribute(String key) throws IOException {
        String valueFromProperties;
        String value = this.getManifest().getMainAttributes().getValue(key);
        if (value == null) {
            return null;
        }
        if (value.startsWith("%") && (valueFromProperties = this.getPluginProperties().getProperty(value.substring(1))) != null) {
            value = valueFromProperties;
        }
        return value;
    }
}

