/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.clean;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.clean.Fileset;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.util.StringUtils;

public class CleanMojo
extends AbstractMojo {
    private MavenProject project;
    private File directory;
    private File outputDirectory;
    private File testOutputDirectory;
    private File reportDirectory;
    private boolean verbose;
    private List filesets;
    private boolean followSymLinks;
    private FileSetManager fileSetManager;
    private boolean skip;
    private boolean failOnError;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Clean is skipped.");
            return;
        }
        try {
            this.fileSetManager = new FileSetManager(this.getLog(), this.verbose);
            this.removeDirectory(this.directory);
            this.removeDirectory(this.outputDirectory);
            this.removeDirectory(this.testOutputDirectory);
            this.removeDirectory(this.reportDirectory);
            this.removeAdditionalFilesets();
        }
        catch (MojoExecutionException e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().warn((CharSequence)e.getMessage());
        }
    }

    private void removeAdditionalFilesets() throws MojoExecutionException {
        if (this.filesets != null && !this.filesets.isEmpty()) {
            Iterator it = this.filesets.iterator();
            while (it.hasNext()) {
                Fileset fileset = (Fileset)((Object)it.next());
                try {
                    this.getLog().info((CharSequence)("Deleting " + (Object)((Object)fileset)));
                    if (!this.project.isExecutionRoot()) {
                        String projectBasedir = StringUtils.replace((String)this.project.getBasedir().getAbsolutePath(), (String)"\\", (String)"/");
                        String filesetDir = StringUtils.replace((String)fileset.getDirectory(), (String)"\\", (String)"/");
                        if (filesetDir.indexOf(projectBasedir) == -1) {
                            fileset.setDirectory(projectBasedir + "/" + filesetDir);
                        }
                    }
                    this.fileSetManager.delete((FileSet)fileset, this.failOnError);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to delete directory: " + fileset.getDirectory() + ". Reason: " + e.getMessage(), (Exception)e);
                }
            }
        }
    }

    private void removeDirectory(File dir) throws MojoExecutionException {
        if (dir != null) {
            if (!dir.exists()) {
                return;
            }
            if (!dir.isDirectory()) {
                throw new MojoExecutionException(dir + " is not a directory.");
            }
            FileSet fs = new FileSet();
            fs.setDirectory(dir.getPath());
            fs.addInclude("**/**");
            fs.setFollowSymlinks(this.followSymLinks);
            try {
                this.getLog().info((CharSequence)("Deleting directory " + dir.getAbsolutePath()));
                this.fileSetManager.delete(fs, this.failOnError);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to delete directory: " + dir + ". Reason: " + e.getMessage(), (Exception)e);
            }
            catch (IllegalStateException e) {
                throw new MojoExecutionException("Failed to delete directory: " + dir + ". Reason: " + e.getMessage(), (Exception)e);
            }
        }
    }

    protected void setDirectory(File newDirectory) {
        this.directory = newDirectory;
    }

    protected void setOutputDirectory(File newOutputDirectory) {
        this.outputDirectory = newOutputDirectory;
    }

    protected void setTestOutputDirectory(File newTestOutputDirectory) {
        this.testOutputDirectory = newTestOutputDirectory;
    }

    protected void setReportDirectory(File newReportDirectory) {
        this.reportDirectory = newReportDirectory;
    }

    public void addFileset(Fileset fileset) {
        if (this.filesets == null) {
            this.filesets = new LinkedList();
        }
        this.filesets.add(fileset);
    }
}

