/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jxls.formula.FormulaController;
import net.sf.jxls.formula.FormulaControllerImpl;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.transformer.Sheet;
import net.sf.jxls.util.SheetHelper;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class Workbook {
    List sheets = new ArrayList();
    HSSFWorkbook hssfWorkbook;
    FormulaController formulaController;
    Configuration configuration = new Configuration();

    public Workbook(HSSFWorkbook hssfWorkbook) {
        this.hssfWorkbook = hssfWorkbook;
    }

    public Workbook(HSSFWorkbook hssfWorkbook, Configuration configuration) {
        this.hssfWorkbook = hssfWorkbook;
        this.configuration = configuration;
    }

    public Workbook(HSSFWorkbook hssfWorkbook, List sheets) {
        this.hssfWorkbook = hssfWorkbook;
        this.sheets = sheets;
    }

    public Workbook(HSSFWorkbook hssfWorkbook, List sheets, Configuration configuration) {
        this.hssfWorkbook = hssfWorkbook;
        this.sheets = sheets;
        this.configuration = configuration;
    }

    public HSSFWorkbook getHssfWorkbook() {
        return this.hssfWorkbook;
    }

    public void setHssfWorkbook(HSSFWorkbook hssfWorkbook) {
        this.hssfWorkbook = hssfWorkbook;
    }

    public void addSheet(Sheet sheet) {
        this.sheets.add(sheet);
        sheet.setWorkbook(this);
    }

    public void initSheetNames() {
        for (int i = 0; i < this.sheets.size(); ++i) {
            Sheet sheet = (Sheet)this.sheets.get(i);
            sheet.initSheetName();
        }
    }

    public Map getListRanges() {
        HashMap listRanges = new HashMap();
        for (int i = 0; i < this.sheets.size(); ++i) {
            Sheet sheet = (Sheet)this.sheets.get(i);
            listRanges.putAll(sheet.getListRanges());
        }
        return listRanges;
    }

    public List findFormulas() {
        ArrayList formulas = new ArrayList();
        for (int i = 0; i < this.sheets.size(); ++i) {
            Sheet sheet = (Sheet)this.sheets.get(i);
            formulas.addAll(SheetHelper.findFormulas(sheet));
        }
        return formulas;
    }

    public Map createFormulaSheetMap() {
        HashMap<String, List> formulas = new HashMap<String, List>();
        for (int i = 0; i < this.sheets.size(); ++i) {
            Sheet sheet = (Sheet)this.sheets.get(i);
            formulas.put(sheet.getSheetName(), SheetHelper.findFormulas(sheet));
        }
        return formulas;
    }

    public FormulaController createFormulaController() {
        this.formulaController = new FormulaControllerImpl(this);
        return this.formulaController;
    }

    public FormulaController getFormulaController() {
        return this.formulaController;
    }

    public List getSheets() {
        return this.sheets;
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public Sheet getSheetAt(int sheetNo) {
        return (Sheet)this.sheets.get(sheetNo);
    }

    public void removeSheetAt(int sheetNo) {
        this.hssfWorkbook.removeSheetAt(sheetNo);
        this.sheets.remove(sheetNo);
    }
}

