/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.server.ipchecker;

import com.dsjdf.jdf.Configuration;
import com.dsjdf.jdf.Logger;
import com.dsjdf.jdf.MessageStore;
import com.dsjdf.jdf.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

public class IPChecker {
    protected List denyMap;
    protected List allowMap;
    private Hashtable curTransactionMap;
    private String serverName;
    private static long allowLastModified;
    private static long denyLastModified;

    public IPChecker(String serverName) {
        this.serverName = serverName;
        this.allowMap = new ArrayList(500);
        this.denyMap = new ArrayList(500);
        this.curTransactionMap = new Hashtable(5000);
    }

    public int isDenyIP(String ip) {
        int ret;
        block6: {
            ret = 0;
            try {
                Configuration conf = new Configuration();
                this.setAllowIPFromFile();
                this.setDenyIPFromFile();
                boolean containsAllowIP = this.isMappingIP(this.allowMap, ip);
                boolean containsDenyIP = this.isMappingIP(this.denyMap, ip);
                if (containsAllowIP && containsDenyIP) {
                    String priorityOrder = "allow";
                    try {
                        priorityOrder = conf.get(String.valueOf(this.serverName) + ".ipfilter.priorityOrder").trim();
                    }
                    catch (Exception e) {
                        priorityOrder = "allow";
                    }
                    ret = priorityOrder.equals("deny") ? 1 : (priorityOrder.equals("allow") || priorityOrder.equals("") ? 0 : 2);
                    break block6;
                }
                if (containsAllowIP || containsDenyIP) {
                    ret = containsAllowIP ? 0 : 1;
                }
            }
            catch (Exception e) {
                Logger.debug.println(this, Utility.getStackTrace(e));
            }
        }
        return ret;
    }

    private boolean isMappingIP(List ipInMap, String ipInClient) {
        boolean ret = true;
        String[] ipInClientDelim = new String[4];
        int idx = 0;
        StringTokenizer st = new StringTokenizer(ipInClient, ".");
        while (st.hasMoreElements()) {
            ipInClientDelim[idx++] = (String)st.nextElement();
        }
        st = null;
        int a = 0;
        while (a < ipInMap.size()) {
            if (!ret) {
                ret = true;
            }
            st = new StringTokenizer((String)ipInMap.get(a), ".");
            String[] ipInMapDelim = new String[]{"*", "*", "*", "*"};
            idx = 0;
            while (st.hasMoreElements()) {
                ipInMapDelim[idx++] = (String)st.nextElement();
            }
            int i = 0;
            while (i < ipInMapDelim.length) {
                if (!ipInMapDelim[i].equals("*") && !ipInMapDelim[i].equals(ipInClientDelim[i])) {
                    ret = false;
                    break;
                }
                ++i;
            }
            if (ret) break;
            ++a;
        }
        return ret;
    }

    public boolean getIsCorrectPriority() {
        boolean ret = false;
        String priorityOrder = "allow";
        try {
            Configuration conf = new Configuration();
            priorityOrder = conf.get(String.valueOf(this.serverName) + ".ipfilter.priorityOrder").trim();
        }
        catch (Exception e) {
            priorityOrder = "allow";
        }
        ret = priorityOrder.equals("deny") ? true : priorityOrder.equals("allow") || priorityOrder.equals("");
        return ret;
    }

    public void emptyDenyMap() {
        this.denyMap.clear();
    }

    public void emptyCurTransactionMap() {
        this.curTransactionMap.clear();
    }

    public List getDenyMap() {
        return this.denyMap;
    }

    private void setAllowIPFromFile() {
        try {
            Configuration conf = new Configuration();
            String filepath = conf.get(String.valueOf(this.serverName) + ".ipfilter.allowIPFile").trim();
            File file = new File(filepath);
            long lastmodified = file.lastModified();
            if (allowLastModified != lastmodified) {
                this.allowMap.clear();
                BufferedReader bis = new BufferedReader(new InputStreamReader(new FileInputStream(filepath)));
                String ip = "";
                while ((ip = bis.readLine()) != null) {
                    if (ip.indexOf(35) == 0) continue;
                    this.allowMap.add(ip.trim());
                }
                bis.close();
                allowLastModified = lastmodified;
            }
        }
        catch (Exception e) {
            MessageStore msg = new MessageStore("WAR003");
            Logger.warn.println(this, msg);
            Logger.debug.println(this, Utility.getStackTrace(e));
        }
    }

    private void setDenyIPFromFile() {
        try {
            Configuration conf = new Configuration();
            String filepath = conf.get(String.valueOf(this.serverName) + ".ipfilter.denyIPFile").trim();
            File file = new File(filepath);
            long lastmodified = file.lastModified();
            if (denyLastModified != lastmodified) {
                this.denyMap.clear();
                BufferedReader bis = new BufferedReader(new InputStreamReader(new FileInputStream(filepath)));
                String ip = "";
                while ((ip = bis.readLine()) != null) {
                    if (ip.indexOf(35) == 0) continue;
                    this.denyMap.add(ip.trim());
                }
                bis.close();
                denyLastModified = lastmodified;
            }
        }
        catch (Exception e) {
            MessageStore msg = new MessageStore("WAR003");
            Logger.warn.println(this, msg);
            Logger.debug.println(this, Utility.getStackTrace(e));
        }
    }
}

