/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.io;

import com.dsjdf.jdf.ConfigurationException;
import com.dsjdf.jdf.Logger;
import com.gpki.secureweb.GPKIKeyInfo;
import com.gpki.secureweb.GPKISecureWEBException;
import com.gpki.util.CryptoTagFinder;
import com.gpki.util.GPKIUtil;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletOutputStream;

public class GPKIServletOutputStream
extends ServletOutputStream {
    GPKIKeyInfo keyinfo;
    private CryptoTagFinder finder;
    private boolean isFinding = false;

    protected GPKIServletOutputStream() {
    }

    public GPKIServletOutputStream(ServletOutputStream out) throws IOException {
        this.init();
    }

    public GPKIServletOutputStream(ServletOutputStream out, GPKIKeyInfo keyinfo) throws IOException {
        this.keyinfo = keyinfo;
        this.init();
    }

    private void init() throws IOException {
        try {
            if (this.finder == null) {
                this.finder = new CryptoTagFinder(this.keyinfo);
            }
        }
        catch (ConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void write(int b) throws IOException {
    }

    public void print(String str) {
        List ret = null;
        try {
            Logger.debug.println((Object)this, "[" + Thread.currentThread().getName() + "] \ubd80\ubd84\uc554\ud638\ud654 \ub370\uc774\ud130 : " + str);
            ret = this.finder.getDelimStringForEncrypt(str);
            int i = 0;
            while (i < ret.size()) {
                char c = str.charAt(i);
                if ((c & 0xFF00) != 0) {
                    throw new CharConversionException("Not an ISO 8859/1 character:  " + c);
                }
                this.write(c);
                ++i;
            }
        }
        catch (GPKISecureWEBException e) {
            try {
                this.write(GPKIUtil.goErrorPage(e).getBytes());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            try {
                this.write(GPKIUtil.goErrorPage(e).getBytes());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void print(boolean b) throws IOException {
        this.print(b ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.print(String.valueOf(c));
    }

    public void print(int i) throws IOException {
        this.print(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.println();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.println();
    }

    public void println(int i) throws IOException {
        this.print(i);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.println();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }
}

