/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.secureweb;

import com.dsjdf.jdf.Logger;
import com.dsjdf.jdf.Utility;
import com.gpki.gpkiapi.crypto.Cipher;
import com.gpki.gpkiapi.crypto.Key;
import com.gpki.gpkiapi.crypto.MessageDigest;
import com.gpki.gpkiapi.crypto.SecretKey;
import com.gpki.gpkiapi.util.Dump;
import com.gpki.secureweb.Base64ContentInfo;
import com.gpki.secureweb.GPKISecureWEBException;
import com.gpki.secureweb.SignContentInfo;

public class EncryptedData
extends Base64ContentInfo {
    String algo = null;
    SecretKey KeyInfo;

    public EncryptedData() {
    }

    public EncryptedData(String base64contentinfo) throws GPKISecureWEBException {
        super(base64contentinfo);
    }

    public void setKey(String algo, byte[] Key, byte[] IV) throws GPKISecureWEBException {
        try {
            this.algo = algo;
            int index = algo.indexOf("/");
            String algorithm = algo;
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] EncryptedData algo : " + algo);
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] EncryptedData Key : " + Key);
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] EncryptedData IV : " + IV);
            if (index > 0) {
                algorithm = algo.substring(0, index);
            }
            this.KeyInfo = new SecretKey(algorithm, Key, IV);
        }
        catch (Exception e) {
            Logger.err.println(this, Utility.getStackTrace(e));
            throw new GPKISecureWEBException(e);
        }
    }

    public byte[] decrypt() throws GPKISecureWEBException {
        byte[] decrypted_data = null;
        byte[] decdata = null;
        try {
            Cipher cipher = Cipher.getInstance((String)this.algo);
            cipher.init(2, (Key)this.KeyInfo);
            decrypted_data = cipher.doFinal(this.contentInfo);
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] ENCRYPTED_DATA decrypted_data = " + Dump.toHexString((byte[])decrypted_data, (long)0L, (long)decrypted_data.length));
            if (this.content_type == 0) {
                decdata = this.checkMessageDigest(decrypted_data);
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] ENCRYPTED_DATA checkMessageDigest(decrypted_data) = " + Dump.toHexString((byte[])decdata, (long)0L, (long)decdata.length));
            } else if (this.content_type == 1 || this.content_type == 2) {
                SignContentInfo signContentInfo = new SignContentInfo(decrypted_data);
                decdata = signContentInfo.getSignData();
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] ENCRYPTED_SIGNDATA decdata = " + Dump.toHexString((byte[])decdata, (long)0L, (long)decdata.length));
            }
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return decdata;
    }

    public String encrypt(String tobeEncData) throws GPKISecureWEBException {
        String encDataWithScript = null;
        StringBuffer encData = new StringBuffer(100);
        Cipher cipher = null;
        try {
            MessageDigest sha256 = MessageDigest.getInstance((String)"SHA256");
            byte[] myHash = sha256.digest(tobeEncData.getBytes());
            byte[] bin_tobeEncData = Utility.concat(tobeEncData.getBytes(), myHash);
            cipher = Cipher.getInstance((String)this.algo);
            cipher.init(1, (Key)this.KeyInfo);
            byte[] bin_encData = cipher.doFinal(bin_tobeEncData);
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] bin_encData : " + Dump.toHexString((byte[])bin_encData, (long)0L, (long)bin_encData.length));
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] EncryptedData encrypt() major : " + this.getMajor());
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] EncryptedData encrypt() minor : " + this.getMinor());
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] EncryptedData encrypt() content_type : " + this.getContentType());
            encData.append("<gpki:ENCRYPTED DATA>");
            encData.append(this.makeBase64ContentInfo(this.getMajor(), this.getMinor(), this.getContentType(), bin_encData));
            encData.append("</gpki:ENCRYPTED DATA>");
            encDataWithScript = Base64ContentInfo.Base64SrciptEncrypt(encData.toString());
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ud074\ub77c\uc774\uc5b8\ud2b8\ub85c \ubcf4\ub0b4\uc8fc\ub294 \uc2a4\ud06c\ub9bd\ud2b8 \ud3ec\ud568\ud55c \ub370\uc774\ud130 : " + encDataWithScript);
        }
        catch (Exception e) {
            Logger.err.println(this, Utility.getStackTrace(e));
            throw new GPKISecureWEBException(e);
        }
        return encDataWithScript;
    }
}

