/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.shared.filtering.FilteringUtils;
import org.codehaus.plexus.interpolation.ValueSource;

public class PropertiesEscapingBackSlashValueSource
implements ValueSource {
    private boolean escapedBackslashesInFilePath;
    private Properties properties;

    public PropertiesEscapingBackSlashValueSource(boolean escapedBackslashesInFilePath, Properties properties) {
        this.escapedBackslashesInFilePath = escapedBackslashesInFilePath;
        this.properties = properties == null ? new Properties() : properties;
    }

    public Object getValue(String expression) {
        String value = this.properties.getProperty(expression);
        return this.escapedBackslashesInFilePath ? FilteringUtils.escapeWindowsPath(value) : value;
    }

    public void clearFeedback() {
    }

    public List getFeedback() {
        return Collections.EMPTY_LIST;
    }
}

