/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.clustering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStaticFailoverStrategy
implements FailoverStrategy {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractStaticFailoverStrategy.class);

    public List<Endpoint> getAlternateEndpoints(Exchange exchange) {
        Endpoint endpoint = (Endpoint)exchange.get(Endpoint.class);
        List services = endpoint.getService().getServiceInfos();
        QName currentBinding = endpoint.getBinding().getBindingInfo().getName();
        ArrayList<Endpoint> alternates = new ArrayList<Endpoint>();
        for (ServiceInfo service : services) {
            Collection candidates = service.getEndpoints();
            for (EndpointInfo candidate : candidates) {
                QName candidateBinding = candidate.getBinding().getName();
                if (candidateBinding.equals(currentBinding)) {
                    Endpoint alternate;
                    if (candidate.getAddress().equals(endpoint.getEndpointInfo().getAddress()) || (alternate = (Endpoint)endpoint.getService().getEndpoints().get(candidate.getName())) == null) continue;
                    LOG.log(Level.INFO, "FAILOVER_CANDIDATE_ACCEPTED", candidate.getName());
                    alternates.add(alternate);
                    continue;
                }
                LOG.log(Level.INFO, "FAILOVER_CANDIDATE_REJECTED", new Object[]{candidate.getName(), candidateBinding});
            }
        }
        return alternates;
    }

    public Endpoint selectAlternateEndpoint(List<Endpoint> alternates) {
        Endpoint selected = null;
        if (alternates != null && alternates.size() > 0) {
            selected = this.getNextAlternate(alternates);
            LOG.log(Level.WARNING, "FAILING_OVER_TO", new Object[]{selected.getEndpointInfo().getName(), selected.getEndpointInfo().getAddress()});
        } else {
            LOG.warning("NO_ALTERNATE_TARGETS_REMAIN");
        }
        return selected;
    }

    protected abstract Endpoint getNextAlternate(List<Endpoint> var1);
}

