/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;
import org.mortbay.util.MultiMap;
import org.mortbay.util.URIUtil;

public class ServletHandler
extends AbstractHandler {
    public static final String __DEFAULT_SERVLET = "default";
    public static final String __J_S_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    public static final String __J_S_ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String __J_S_ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String __J_S_ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String __J_S_ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String __J_S_ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String __J_S_ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    private ContextHandler _contextHandler;
    private ContextHandler.SContext _servletContext;
    private FilterHolder[] _filters;
    private FilterMapping[] _filterMappings;
    private boolean _filterChainsCached = true;
    private int _maxFilterChainsCacheSize = 1000;
    private boolean _startWithUnavailable = true;
    private ServletHolder[] _servlets;
    private ServletMapping[] _servletMappings;
    private transient Map _filterNameMap = new HashMap();
    private transient List _filterPathMappings;
    private transient MultiMap _filterNameMappings;
    private transient Map _servletNameMap = new HashMap();
    private transient PathMap _servletPathMap;
    protected transient HashMap[] _chainCache;

    public void setServer(Server server) {
        if (this.getServer() != null && this.getServer() != server) {
            this.getServer().getContainer().update((Object)this, (Object[])this._filters, null, "filter", true);
            this.getServer().getContainer().update((Object)this, (Object[])this._filterMappings, null, "filterMapping", true);
            this.getServer().getContainer().update((Object)this, (Object[])this._servlets, null, "servlet", true);
            this.getServer().getContainer().update((Object)this, (Object[])this._servletMappings, null, "servletMapping", true);
        }
        if (server != null && this.getServer() != server) {
            server.getContainer().update((Object)this, null, (Object[])this._filters, "filter", true);
            server.getContainer().update((Object)this, null, (Object[])this._filterMappings, "filterMapping", true);
            server.getContainer().update((Object)this, null, (Object[])this._servlets, "servlet", true);
            server.getContainer().update((Object)this, null, (Object[])this._servletMappings, "servletMapping", true);
        }
        super.setServer(server);
    }

    protected synchronized void doStart() throws Exception {
        this._servletContext = ContextHandler.getCurrentContext();
        this._contextHandler = this._servletContext == null ? null : this._servletContext.getContextHandler();
        this.updateNameMappings();
        this.updateMappings();
        if (this._filterChainsCached) {
            this._chainCache = new HashMap[]{null, new HashMap(), new HashMap(), null, new HashMap(), null, null, null, new HashMap()};
        }
        super.doStart();
        if (this._contextHandler == null || !(this._contextHandler instanceof Context)) {
            this.initialize();
        }
    }

    protected synchronized void doStop() throws Exception {
        int i;
        super.doStop();
        if (this._filters != null) {
            i = this._filters.length;
            while (i-- > 0) {
                try {
                    this._filters[i].stop();
                }
                catch (Exception e) {
                    Log.warn((String)"EXCEPTION ", (Throwable)e);
                }
            }
        }
        if (this._servlets != null) {
            i = this._servlets.length;
            while (i-- > 0) {
                try {
                    this._servlets[i].stop();
                }
                catch (Exception e) {
                    Log.warn((String)"EXCEPTION ", (Throwable)e);
                }
            }
        }
        this._filterPathMappings = null;
        this._filterNameMappings = null;
        this._servletPathMap = null;
        this._chainCache = null;
    }

    public Object getContextLog() {
        return null;
    }

    public FilterMapping[] getFilterMappings() {
        return this._filterMappings;
    }

    public FilterHolder[] getFilters() {
        return this._filters;
    }

    public PathMap.Entry getHolderEntry(String pathInContext) {
        if (this._servletPathMap == null) {
            return null;
        }
        return this._servletPathMap.getMatch(pathInContext);
    }

    public boolean matchesPath(String pathInContext) {
        return this._servletPathMap.containsMatch(pathInContext);
    }

    public RequestDispatcher getRequestDispatcher(String uriInContext) {
        if (uriInContext == null) {
            return null;
        }
        if (!uriInContext.startsWith("/")) {
            return null;
        }
        try {
            String query = null;
            int q = 0;
            q = uriInContext.indexOf(63);
            if (q > 0) {
                query = uriInContext.substring(q + 1);
                uriInContext = uriInContext.substring(0, q);
            }
            if ((q = uriInContext.indexOf(59)) > 0) {
                uriInContext = uriInContext.substring(0, q);
            }
            String pathInContext = URIUtil.canonicalPath((String)URIUtil.decodePath((String)uriInContext));
            String uri = URIUtil.addPaths((String)this._contextHandler.getContextPath(), (String)uriInContext);
            return new Dispatcher(this._contextHandler, uri, pathInContext, query);
        }
        catch (Exception e) {
            Log.ignore((Throwable)e);
            return null;
        }
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public ServletMapping[] getServletMappings() {
        return this._servletMappings;
    }

    public ServletHolder[] getServlets() {
        return this._servlets;
    }

    public ServletHolder getServlet(String name) {
        return (ServletHolder)this._servletNameMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int type) throws IOException, ServletException {
        Map old_role_map;
        String old_path_info;
        String old_servlet_path;
        String old_servlet_name;
        Request base_request;
        block54: {
            if (!this.isStarted()) {
                return;
            }
            base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
            old_servlet_name = base_request.getServletName();
            old_servlet_path = base_request.getServletPath();
            old_path_info = base_request.getPathInfo();
            old_role_map = base_request.getRoleMap();
            Object request_listeners = null;
            ServletRequestEvent request_event = null;
            try {
                block52: {
                    try {
                        FilterChain chain;
                        ServletHolder servlet_holder;
                        block57: {
                            block56: {
                                servlet_holder = null;
                                chain = null;
                                if (!target.startsWith("/")) break block56;
                                PathMap.Entry entry = this.getHolderEntry(target);
                                if (entry != null) {
                                    servlet_holder = (ServletHolder)entry.getValue();
                                    base_request.setServletName(servlet_holder.getName());
                                    base_request.setRoleMap(servlet_holder.getRoleMap());
                                    if (Log.isDebugEnabled()) {
                                        Log.debug((String)("servlet=" + servlet_holder));
                                    }
                                    String servlet_path_spec = (String)entry.getKey();
                                    String servlet_path = entry.getMapped() != null ? entry.getMapped() : PathMap.pathMatch(servlet_path_spec, target);
                                    String path_info = PathMap.pathInfo(servlet_path_spec, target);
                                    if (type == 4) {
                                        base_request.setAttribute("javax.servlet.include.servlet_path", servlet_path);
                                        base_request.setAttribute("javax.servlet.include.path_info", path_info);
                                    } else {
                                        base_request.setServletPath(servlet_path);
                                        base_request.setPathInfo(path_info);
                                    }
                                    if (servlet_holder != null && this._filterMappings != null && this._filterMappings.length > 0) {
                                        chain = this.getFilterChain(type, target, servlet_holder);
                                    }
                                }
                                break block57;
                            }
                            servlet_holder = (ServletHolder)this._servletNameMap.get(target);
                            if (servlet_holder != null && this._filterMappings != null && this._filterMappings.length > 0) {
                                base_request.setServletName(servlet_holder.getName());
                                chain = this.getFilterChain(type, null, servlet_holder);
                            }
                        }
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)("chain=" + chain));
                            Log.debug((String)("servlet holder=" + servlet_holder));
                        }
                        if ((request_listeners = base_request.takeRequestListeners()) != null) {
                            request_event = new ServletRequestEvent(this.getServletContext(), (ServletRequest)request);
                            int s = LazyList.size((Object)request_listeners);
                            for (int i = 0; i < s; ++i) {
                                ServletRequestListener listener = (ServletRequestListener)LazyList.get((Object)request_listeners, (int)i);
                                listener.requestInitialized(request_event);
                            }
                        }
                        if (servlet_holder != null) {
                            base_request.setHandled(true);
                            if (chain != null) {
                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                break block52;
                            } else {
                                servlet_holder.handle((ServletRequest)request, (ServletResponse)response);
                            }
                            break block52;
                        }
                        this.notFound(request, response);
                    }
                    catch (RetryRequest e) {
                        base_request.setHandled(false);
                        throw e;
                    }
                    catch (EofException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        block53: {
                            Throwable th;
                            block58: {
                                if (type != 1) {
                                    if (e instanceof IOException) {
                                        throw (IOException)e;
                                    }
                                    if (e instanceof RuntimeException) {
                                        throw (RuntimeException)e;
                                    }
                                    if (e instanceof ServletException) {
                                        throw (ServletException)((Object)e);
                                    }
                                }
                                if ((th = e) instanceof UnavailableException) {
                                    Log.debug((Throwable)th);
                                } else if (th instanceof ServletException) {
                                    Log.debug((Throwable)th);
                                    Throwable cause = ((ServletException)th).getRootCause();
                                    if (cause != th && cause != null) {
                                        th = cause;
                                    }
                                }
                                if (th instanceof RetryRequest) {
                                    base_request.setHandled(false);
                                    throw (RetryRequest)th;
                                }
                                if (th instanceof HttpException) {
                                    throw (HttpException)th;
                                }
                                if (Log.isDebugEnabled()) {
                                    Log.warn((String)request.getRequestURI(), (Throwable)th);
                                    Log.debug((String)request.toString());
                                } else if (th instanceof IOException || th instanceof UnavailableException) {
                                    Log.warn((String)(request.getRequestURI() + ": " + th));
                                } else {
                                    Log.warn((String)request.getRequestURI(), (Throwable)th);
                                }
                                if (response.isCommitted()) break block58;
                                request.setAttribute(__J_S_ERROR_EXCEPTION_TYPE, th.getClass());
                                request.setAttribute(__J_S_ERROR_EXCEPTION, (Object)th);
                                if (th instanceof UnavailableException) {
                                    UnavailableException ue = (UnavailableException)th;
                                    if (ue.isPermanent()) {
                                        response.sendError(404, th.getMessage());
                                        break block53;
                                    } else {
                                        response.sendError(503, th.getMessage());
                                    }
                                    break block53;
                                } else {
                                    response.sendError(500, th.getMessage());
                                }
                                break block53;
                            }
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)("Response already committed for handling " + th));
                            }
                        }
                        Object var19_27 = null;
                        if (request_listeners != null) {
                            int i = LazyList.size((Object)request_listeners);
                            while (i-- > 0) {
                                ServletRequestListener listener = (ServletRequestListener)LazyList.get((Object)request_listeners, (int)i);
                                listener.requestDestroyed(request_event);
                            }
                        }
                        base_request.setServletName(old_servlet_name);
                        base_request.setRoleMap(old_role_map);
                        if (type == 4) return;
                        base_request.setServletPath(old_servlet_path);
                        base_request.setPathInfo(old_path_info);
                        return;
                    }
                    catch (Error e) {
                        if (type != 1) {
                            throw e;
                        }
                        Log.warn((String)("Error for " + request.getRequestURI()), (Throwable)e);
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)request.toString());
                        }
                        if (!response.isCommitted()) {
                            request.setAttribute(__J_S_ERROR_EXCEPTION_TYPE, e.getClass());
                            request.setAttribute(__J_S_ERROR_EXCEPTION, (Object)e);
                            response.sendError(500, e.getMessage());
                        } else if (Log.isDebugEnabled()) {
                            Log.debug((String)"Response already committed for handling ", (Object)e);
                        }
                        Object var19_28 = null;
                        if (request_listeners != null) {
                            int i = LazyList.size((Object)request_listeners);
                            while (i-- > 0) {
                                ServletRequestListener listener = (ServletRequestListener)LazyList.get((Object)request_listeners, (int)i);
                                listener.requestDestroyed(request_event);
                            }
                        }
                        base_request.setServletName(old_servlet_name);
                        base_request.setRoleMap(old_role_map);
                        if (type == 4) return;
                        base_request.setServletPath(old_servlet_path);
                        base_request.setPathInfo(old_path_info);
                        return;
                    }
                }
                Object var19_26 = null;
                if (request_listeners == null) break block54;
            }
            catch (Throwable throwable) {
                Object var19_29 = null;
                if (request_listeners != null) {
                    int i = LazyList.size(request_listeners);
                    while (i-- > 0) {
                        ServletRequestListener listener = (ServletRequestListener)LazyList.get(request_listeners, (int)i);
                        listener.requestDestroyed(request_event);
                    }
                }
                base_request.setServletName(old_servlet_name);
                base_request.setRoleMap(old_role_map);
                if (type == 4) throw throwable;
                base_request.setServletPath(old_servlet_path);
                base_request.setPathInfo(old_path_info);
                throw throwable;
            }
            int i = LazyList.size((Object)request_listeners);
            while (i-- > 0) {
                ServletRequestListener listener = (ServletRequestListener)LazyList.get((Object)request_listeners, (int)i);
                listener.requestDestroyed(request_event);
            }
        }
        base_request.setServletName(old_servlet_name);
        base_request.setRoleMap(old_role_map);
        if (type == 4) return;
        base_request.setServletPath(old_servlet_path);
        base_request.setPathInfo(old_path_info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterChain getFilterChain(int requestType, String pathInContext, ServletHolder servletHolder) {
        String key;
        String string = key = pathInContext == null ? servletHolder.getName() : pathInContext;
        if (this._filterChainsCached && this._chainCache != null) {
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (this._chainCache[requestType].containsKey(key)) {
                    return (FilterChain)this._chainCache[requestType].get(key);
                }
            }
        }
        Object filters = null;
        if (pathInContext != null && this._filterPathMappings != null) {
            for (int i = 0; i < this._filterPathMappings.size(); ++i) {
                FilterMapping mapping = (FilterMapping)this._filterPathMappings.get(i);
                if (!mapping.appliesTo(pathInContext, requestType)) continue;
                filters = LazyList.add(filters, (Object)mapping.getFilterHolder());
            }
        }
        if (servletHolder != null && this._filterNameMappings != null && this._filterNameMappings.size() > 0 && this._filterNameMappings.size() > 0) {
            FilterMapping mapping;
            int i;
            Object o = this._filterNameMappings.get((Object)servletHolder.getName());
            for (i = 0; i < LazyList.size((Object)o); ++i) {
                mapping = (FilterMapping)LazyList.get((Object)o, (int)i);
                if (!mapping.appliesTo(requestType)) continue;
                filters = LazyList.add((Object)filters, (Object)mapping.getFilterHolder());
            }
            o = this._filterNameMappings.get((Object)"*");
            for (i = 0; i < LazyList.size((Object)o); ++i) {
                mapping = (FilterMapping)LazyList.get((Object)o, (int)i);
                if (!mapping.appliesTo(requestType)) continue;
                filters = LazyList.add((Object)filters, (Object)mapping.getFilterHolder());
            }
        }
        if (filters == null) {
            return null;
        }
        Object chain = null;
        if (this._filterChainsCached) {
            if (LazyList.size(filters) > 0) {
                chain = new CachedChain(filters, servletHolder);
            }
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (this._maxFilterChainsCacheSize > 0 && this._chainCache[requestType].size() > this._maxFilterChainsCacheSize) {
                    this._chainCache[requestType].clear();
                }
                this._chainCache[requestType].put(key, chain);
            }
        } else if (LazyList.size(filters) > 0) {
            chain = new Chain(filters, servletHolder);
        }
        return chain;
    }

    public boolean isInitializeAtStart() {
        return false;
    }

    public void setInitializeAtStart(boolean initializeAtStart) {
    }

    public boolean isAvailable() {
        if (!this.isStarted()) {
            return false;
        }
        ServletHolder[] holders = this.getServlets();
        for (int i = 0; i < holders.length; ++i) {
            ServletHolder holder = holders[i];
            if (holder == null || holder.isAvailable()) continue;
            return false;
        }
        return true;
    }

    public void setStartWithUnavailable(boolean start) {
        this._startWithUnavailable = start;
    }

    public boolean isStartWithUnavailable() {
        return this._startWithUnavailable;
    }

    public void initialize() throws Exception {
        MultiException mx = new MultiException();
        if (this._filters != null) {
            for (int i = 0; i < this._filters.length; ++i) {
                this._filters[i].start();
            }
        }
        if (this._servlets != null) {
            Object[] servlets = (ServletHolder[])this._servlets.clone();
            Arrays.sort(servlets);
            for (int i = 0; i < servlets.length; ++i) {
                try {
                    if (((Holder)servlets[i]).getClassName() == null && ((ServletHolder)servlets[i]).getForcedPath() != null) {
                        ServletHolder forced_holder = (ServletHolder)this._servletPathMap.match(((ServletHolder)servlets[i]).getForcedPath());
                        if (forced_holder == null || forced_holder.getClassName() == null) {
                            mx.add((Throwable)new IllegalStateException("No forced path servlet for " + ((ServletHolder)servlets[i]).getForcedPath()));
                            continue;
                        }
                        ((Holder)servlets[i]).setClassName(forced_holder.getClassName());
                    }
                    servlets[i].start();
                    continue;
                }
                catch (Throwable e) {
                    Log.debug((String)"EXCEPTION ", (Object)e);
                    mx.add(e);
                }
            }
            mx.ifExceptionThrow();
        }
    }

    public boolean isFilterChainsCached() {
        return this._filterChainsCached;
    }

    public ServletHolder newServletHolder() {
        return new ServletHolder();
    }

    public ServletHolder newServletHolder(Class servlet) {
        return new ServletHolder(servlet);
    }

    public ServletHolder addServletWithMapping(String className, String pathSpec) {
        ServletHolder holder = this.newServletHolder(null);
        holder.setName(className + "-" + holder.hashCode());
        holder.setClassName(className);
        this.addServletWithMapping(holder, pathSpec);
        return holder;
    }

    public ServletHolder addServletWithMapping(Class servlet, String pathSpec) {
        ServletHolder holder = this.newServletHolder(servlet);
        this.setServlets((ServletHolder[])LazyList.addToArray((Object[])this.getServlets(), (Object)holder, (Class)ServletHolder.class));
        this.addServletWithMapping(holder, pathSpec);
        return holder;
    }

    public void addServletWithMapping(ServletHolder servlet, String pathSpec) {
        Object[] holders = this.getServlets();
        if (holders != null) {
            holders = (ServletHolder[])holders.clone();
        }
        try {
            this.setServlets((ServletHolder[])LazyList.addToArray((Object[])holders, (Object)servlet, (Class)ServletHolder.class));
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(servlet.getName());
            mapping.setPathSpec(pathSpec);
            this.setServletMappings((ServletMapping[])LazyList.addToArray((Object[])this.getServletMappings(), (Object)mapping, (Class)ServletMapping.class));
        }
        catch (Exception e) {
            this.setServlets((ServletHolder[])holders);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public ServletHolder addServlet(String className, String pathSpec) {
        return this.addServletWithMapping(className, pathSpec);
    }

    public void addServlet(ServletHolder holder) {
        this.setServlets((ServletHolder[])LazyList.addToArray((Object[])this.getServlets(), (Object)holder, (Class)ServletHolder.class));
    }

    public void addServletMapping(ServletMapping mapping) {
        this.setServletMappings((ServletMapping[])LazyList.addToArray((Object[])this.getServletMappings(), (Object)mapping, (Class)ServletMapping.class));
    }

    public FilterHolder newFilterHolder(Class filter) {
        return new FilterHolder(filter);
    }

    public FilterHolder newFilterHolder() {
        return new FilterHolder();
    }

    public FilterHolder getFilter(String name) {
        return (FilterHolder)this._filterNameMap.get(name);
    }

    public FilterHolder addFilterWithMapping(Class filter, String pathSpec, int dispatches) {
        FilterHolder holder = this.newFilterHolder(filter);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public FilterHolder addFilterWithMapping(String className, String pathSpec, int dispatches) {
        FilterHolder holder = this.newFilterHolder(null);
        holder.setName(className + "-" + holder.hashCode());
        holder.setClassName(className);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public void addFilterWithMapping(FilterHolder holder, String pathSpec, int dispatches) {
        Object[] holders = this.getFilters();
        if (holders != null) {
            holders = (FilterHolder[])holders.clone();
        }
        try {
            this.setFilters((FilterHolder[])LazyList.addToArray((Object[])holders, (Object)holder, (Class)FilterHolder.class));
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            mapping.setPathSpec(pathSpec);
            mapping.setDispatches(dispatches);
            this.setFilterMappings((FilterMapping[])LazyList.addToArray((Object[])this.getFilterMappings(), (Object)mapping, (Class)FilterMapping.class));
        }
        catch (RuntimeException e) {
            this.setFilters((FilterHolder[])holders);
            throw e;
        }
        catch (Error e) {
            this.setFilters((FilterHolder[])holders);
            throw e;
        }
    }

    public FilterHolder addFilter(String className, String pathSpec, int dispatches) {
        return this.addFilterWithMapping(className, pathSpec, dispatches);
    }

    public void addFilter(FilterHolder filter, FilterMapping filterMapping) {
        if (filter != null) {
            this.setFilters((FilterHolder[])LazyList.addToArray((Object[])this.getFilters(), (Object)filter, (Class)FilterHolder.class));
        }
        if (filterMapping != null) {
            this.setFilterMappings((FilterMapping[])LazyList.addToArray((Object[])this.getFilterMappings(), (Object)filterMapping, (Class)FilterMapping.class));
        }
    }

    public void addFilter(FilterHolder filter) {
        if (filter != null) {
            this.setFilters((FilterHolder[])LazyList.addToArray((Object[])this.getFilters(), (Object)filter, (Class)FilterHolder.class));
        }
    }

    public void addFilterMapping(FilterMapping mapping) {
        if (mapping != null) {
            this.setFilterMappings((FilterMapping[])LazyList.addToArray((Object[])this.getFilterMappings(), (Object)mapping, (Class)FilterMapping.class));
        }
    }

    protected synchronized void updateNameMappings() {
        int i;
        this._filterNameMap.clear();
        if (this._filters != null) {
            for (i = 0; i < this._filters.length; ++i) {
                this._filterNameMap.put(this._filters[i].getName(), this._filters[i]);
                this._filters[i].setServletHandler(this);
            }
        }
        this._servletNameMap.clear();
        if (this._servlets != null) {
            for (i = 0; i < this._servlets.length; ++i) {
                this._servletNameMap.put(this._servlets[i].getName(), this._servlets[i]);
                this._servlets[i].setServletHandler(this);
            }
        }
    }

    protected synchronized void updateMappings() {
        if (this._filterMappings == null) {
            this._filterPathMappings = null;
            this._filterNameMappings = null;
        } else {
            this._filterPathMappings = new ArrayList();
            this._filterNameMappings = new MultiMap();
            for (int i = 0; i < this._filterMappings.length; ++i) {
                FilterHolder filter_holder = (FilterHolder)this._filterNameMap.get(this._filterMappings[i].getFilterName());
                if (filter_holder == null) {
                    throw new IllegalStateException("No filter named " + this._filterMappings[i].getFilterName());
                }
                this._filterMappings[i].setFilterHolder(filter_holder);
                if (this._filterMappings[i].getPathSpecs() != null) {
                    this._filterPathMappings.add(this._filterMappings[i]);
                }
                if (this._filterMappings[i].getServletNames() == null) continue;
                String[] names = this._filterMappings[i].getServletNames();
                for (int j = 0; j < names.length; ++j) {
                    if (names[j] == null) continue;
                    this._filterNameMappings.add((Object)names[j], (Object)this._filterMappings[i]);
                }
            }
        }
        if (this._servletMappings == null || this._servletNameMap == null) {
            this._servletPathMap = null;
        } else {
            PathMap pm = new PathMap();
            for (int i = 0; i < this._servletMappings.length; ++i) {
                ServletHolder servlet_holder = (ServletHolder)this._servletNameMap.get(this._servletMappings[i].getServletName());
                if (servlet_holder == null) {
                    throw new IllegalStateException("No such servlet: " + this._servletMappings[i].getServletName());
                }
                if (this._servletMappings[i].getPathSpecs() == null) continue;
                String[] pathSpecs = this._servletMappings[i].getPathSpecs();
                for (int j = 0; j < pathSpecs.length; ++j) {
                    if (pathSpecs[j] == null) continue;
                    pm.put(pathSpecs[j], servlet_holder);
                }
            }
            this._servletPathMap = pm;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("filterNameMap=" + this._filterNameMap));
            Log.debug((String)("pathFilters=" + this._filterPathMappings));
            Log.debug((String)("servletFilterMap=" + this._filterNameMappings));
            Log.debug((String)("servletPathMap=" + this._servletPathMap));
            Log.debug((String)("servletNameMap=" + this._servletNameMap));
        }
        try {
            if (this.isStarted()) {
                this.initialize();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Not Found " + request.getRequestURI()));
        }
        response.sendError(404);
    }

    public void setFilterChainsCached(boolean filterChainsCached) {
        this._filterChainsCached = filterChainsCached;
    }

    public void setFilterMappings(FilterMapping[] filterMappings) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._filterMappings, (Object[])filterMappings, "filterMapping", true);
        }
        this._filterMappings = filterMappings;
        this.updateMappings();
    }

    public synchronized void setFilters(FilterHolder[] holders) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._filters, (Object[])holders, "filter", true);
        }
        this._filters = holders;
        this.updateNameMappings();
    }

    public void setServletMappings(ServletMapping[] servletMappings) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._servletMappings, (Object[])servletMappings, "servletMapping", true);
        }
        this._servletMappings = servletMappings;
        this.updateMappings();
    }

    public synchronized void setServlets(ServletHolder[] holders) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._servlets, (Object[])holders, "servlet", true);
        }
        this._servlets = holders;
        this.updateNameMappings();
    }

    public int getMaxFilterChainsCacheSize() {
        return this._maxFilterChainsCacheSize;
    }

    public void setMaxFilterChainsCacheSize(int maxFilterChainsCacheSize) {
        this._maxFilterChainsCacheSize = maxFilterChainsCacheSize;
    }

    public Servlet customizeServlet(Servlet servlet) throws Exception {
        return servlet;
    }

    public Servlet customizeServletDestroy(Servlet servlet) throws Exception {
        return servlet;
    }

    public Filter customizeFilter(Filter filter) throws Exception {
        return filter;
    }

    public Filter customizeFilterDestroy(Filter filter) throws Exception {
        return filter;
    }

    private class Chain
    implements FilterChain {
        int _filter = 0;
        Object _chain;
        ServletHolder _servletHolder;

        Chain(Object filters, ServletHolder servletHolder) {
            this._chain = filters;
            this._servletHolder = servletHolder;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("doFilter " + this._filter));
            }
            if (this._filter < LazyList.size((Object)this._chain)) {
                FilterHolder holder = (FilterHolder)LazyList.get((Object)this._chain, (int)this._filter++);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("call filter " + holder));
                }
                Filter filter = holder.getFilter();
                filter.doFilter(request, response, (FilterChain)this);
                return;
            }
            if (this._servletHolder != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("call servlet " + this._servletHolder));
                }
                this._servletHolder.handle(request, response);
            } else {
                ServletHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < LazyList.size((Object)this._chain); ++i) {
                b.append(LazyList.get((Object)this._chain, (int)i).toString());
                b.append("->");
            }
            b.append(this._servletHolder);
            return b.toString();
        }
    }

    private class CachedChain
    implements FilterChain {
        FilterHolder _filterHolder;
        CachedChain _next;
        ServletHolder _servletHolder;

        CachedChain(Object filters, ServletHolder servletHolder) {
            if (LazyList.size((Object)filters) > 0) {
                this._filterHolder = (FilterHolder)LazyList.get((Object)filters, (int)0);
                filters = LazyList.remove((Object)filters, (int)0);
                this._next = new CachedChain(filters, servletHolder);
            } else {
                this._servletHolder = servletHolder;
            }
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this._filterHolder != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("call filter " + this._filterHolder));
                }
                Filter filter = this._filterHolder.getFilter();
                filter.doFilter(request, response, (FilterChain)this._next);
                return;
            }
            if (this._servletHolder != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("call servlet " + this._servletHolder));
                }
                this._servletHolder.handle(request, response);
            } else {
                ServletHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }

        public String toString() {
            if (this._filterHolder != null) {
                return this._filterHolder + "->" + this._next.toString();
            }
            if (this._servletHolder != null) {
                return this._servletHolder.toString();
            }
            return "null";
        }
    }
}

