/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import [Ljava.lang.String;;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.Property;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.AbstractStep;
import org.dbunit.database.DatabaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbConfig
extends ProjectComponent {
    private static final Logger logger = LoggerFactory.getLogger((Class)AbstractStep.class);
    private Set properties = new HashSet();
    private Set features = new HashSet();

    public void addProperty(Property property) {
        logger.debug("addProperty(property={}) - start)", (Object)property);
        this.properties.add(property);
    }

    public void addFeature(Feature feature) {
        logger.debug("addFeature(feature={}) - start)", (Object)feature);
        this.features.add(feature);
    }

    public void copyTo(DatabaseConfig config) throws DatabaseUnitException {
        Iterator iterator = this.features.iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            String fullFeatureName = this.findFeatureByShortName(feature.getName());
            config.setFeature(fullFeatureName, feature.isValue());
        }
        iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            Property prop = (Property)iterator.next();
            String propName = prop.getName();
            String propValue = prop.getValue();
            DatabaseConfig.ConfigProperty dbunitProp = this.findByShortName(propName);
            if (dbunitProp == null) {
                logger.info("Could not set property '" + prop + "'");
                continue;
            }
            String fullPropName = dbunitProp.getProperty();
            config.setProperty(fullPropName, this.createObjectFromString(dbunitProp, propValue));
        }
    }

    private Object createObjectFromString(DatabaseConfig.ConfigProperty dbunitProp, String propValue) throws DatabaseUnitException {
        if (dbunitProp == null) {
            throw new NullPointerException("The parameter 'dbunitProp' must not be null");
        }
        if (propValue == null) {
            return null;
        }
        Class targetClass = dbunitProp.getPropertyType();
        if (targetClass == String.class) {
            return propValue;
        }
        if (targetClass == String;.class) {
            String[] result = propValue.split(",");
            for (int i = 0; i < result.length; ++i) {
                result[i] = result[i].trim();
            }
            return result;
        }
        if (targetClass == Integer.class) {
            return new Integer(propValue);
        }
        return this.createInstance(propValue);
    }

    private Object createInstance(String className) throws DatabaseUnitException {
        try {
            Object o = Class.forName(className).newInstance();
            return o;
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseUnitException("Class Not Found: '" + className + "' could not be loaded", e);
        }
        catch (IllegalAccessException e) {
            throw new DatabaseUnitException("Illegal Access: '" + className + "' could not be loaded", e);
        }
        catch (InstantiationException e) {
            throw new DatabaseUnitException("Instantiation Exception: '" + className + "' could not be loaded", e);
        }
    }

    private DatabaseConfig.ConfigProperty findByShortName(String propShortName) {
        for (int i = 0; i < DatabaseConfig.ALL_PROPERTIES.length; ++i) {
            String fullProperty = DatabaseConfig.ALL_PROPERTIES[i].getProperty();
            if (!fullProperty.endsWith(propShortName)) continue;
            return DatabaseConfig.ALL_PROPERTIES[i];
        }
        logger.info("The property ending with '" + propShortName + "' was not found. " + "Please notify a dbunit developer to add the property to the " + DatabaseConfig.class);
        return null;
    }

    private String findFeatureByShortName(String featureShortName) {
        for (int i = 0; i < DatabaseConfig.ALL_FEATURES.length; ++i) {
            if (!DatabaseConfig.ALL_FEATURES[i].endsWith(featureShortName)) continue;
            return DatabaseConfig.ALL_FEATURES[i];
        }
        logger.info("The feature ending with '" + featureShortName + "' was not found. " + "Please notify a dbunit developer to add the feature to the " + DatabaseConfig.class);
        return null;
    }

    public static class Feature {
        private String name;
        private boolean value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }
    }
}

