/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitRuntimeException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseTableIterator;
import org.dbunit.database.DatabaseTableMetaData;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IMetadataHandler;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.dataset.OrderedTableNameMap;
import org.dbunit.dataset.filter.ITableFilterSimple;
import org.dbunit.util.QualifiedTableName;
import org.dbunit.util.SQLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)DatabaseDataSet.class);
    private final IDatabaseConnection _connection;
    private OrderedTableNameMap _tableMap = null;
    private final ITableFilterSimple _tableFilter;
    private final ITableFilterSimple _oracleRecycleBinTableFilter;

    DatabaseDataSet(IDatabaseConnection connection) throws SQLException {
        this(connection, connection.getConfig().getFeature("http://www.dbunit.org/features/caseSensitiveTableNames"));
    }

    public DatabaseDataSet(IDatabaseConnection connection, boolean caseSensitiveTableNames) throws SQLException {
        this(connection, caseSensitiveTableNames, null);
    }

    public DatabaseDataSet(IDatabaseConnection connection, boolean caseSensitiveTableNames, ITableFilterSimple tableFilter) throws SQLException {
        super(caseSensitiveTableNames);
        if (connection == null) {
            throw new NullPointerException("The parameter 'connection' must not be null");
        }
        this._connection = connection;
        this._tableFilter = tableFilter;
        this._oracleRecycleBinTableFilter = new OracleRecycleBinTableFilter(connection.getConfig());
    }

    static String getSelectStatement(String schema, ITableMetaData metaData, String escapePattern) throws DataSetException {
        int i;
        if (logger.isDebugEnabled()) {
            logger.debug("getSelectStatement(schema={}, metaData={}, escapePattern={}) - start", new Object[]{schema, metaData, escapePattern});
        }
        Column[] columns = metaData.getColumns();
        Column[] primaryKeys = metaData.getPrimaryKeys();
        if (columns.length == 0) {
            throw new DatabaseUnitRuntimeException("At least one column is required to build a valid select statement. Cannot load data for " + metaData);
        }
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("select ");
        for (i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sqlBuffer.append(", ");
            }
            String columnName = new QualifiedTableName(columns[i].getColumnName(), null, escapePattern).getQualifiedName();
            sqlBuffer.append(columnName);
        }
        sqlBuffer.append(" from ");
        sqlBuffer.append(new QualifiedTableName(metaData.getTableName(), schema, escapePattern).getQualifiedName());
        for (i = 0; i < primaryKeys.length; ++i) {
            if (i == 0) {
                sqlBuffer.append(" order by ");
            } else {
                sqlBuffer.append(", ");
            }
            sqlBuffer.append(new QualifiedTableName(primaryKeys[i].getColumnName(), null, escapePattern).getQualifiedName());
        }
        return sqlBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws DataSetException {
        logger.debug("initialize() - start");
        if (this._tableMap != null) {
            return;
        }
        try {
            logger.debug("Initializing the data set from the database...");
            Connection jdbcConnection = this._connection.getConnection();
            DatabaseMetaData databaseMetaData = jdbcConnection.getMetaData();
            String schema = this._connection.getSchema();
            if (SQLHelper.isSybaseDb(jdbcConnection.getMetaData()) && !jdbcConnection.getMetaData().getUserName().equals(schema)) {
                logger.warn("For sybase the schema name should be equal to the user name. Otherwise the DatabaseMetaData#getTables() method might not return any columns. See dbunit tracker #1628896 and http://issues.apache.org/jira/browse/TORQUE-40?page=all");
            }
            DatabaseConfig config = this._connection.getConfig();
            String[] tableType = (String[])config.getProperty("http://www.dbunit.org/properties/tableType");
            IMetadataHandler metadataHandler = (IMetadataHandler)config.getProperty("http://www.dbunit.org/properties/metadataHandler");
            ResultSet resultSet = databaseMetaData.getTables(null, schema, "%", tableType);
            try {
                OrderedTableNameMap tableMap = super.createTableNameMap();
                while (resultSet.next()) {
                    String schemaName = metadataHandler.getSchema(resultSet);
                    String tableName = resultSet.getString(3);
                    if (this._tableFilter != null && !this._tableFilter.accept(tableName)) {
                        logger.debug("Skipping table '{}'", (Object)tableName);
                        continue;
                    }
                    if (!this._oracleRecycleBinTableFilter.accept(tableName)) {
                        logger.debug("Skipping oracle recycle bin table '{}'", (Object)tableName);
                        continue;
                    }
                    QualifiedTableName qualifiedTableName = new QualifiedTableName(tableName, schemaName);
                    tableName = qualifiedTableName.getQualifiedNameIfEnabled(config);
                    tableMap.add(tableName, null);
                }
                this._tableMap = tableMap;
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        }
        String[] names = this.getTableNames();
        if (reversed) {
            names = DataSetUtils.reverseStringArray(names);
        }
        return new DatabaseTableIterator(names, this);
    }

    public String[] getTableNames() throws DataSetException {
        this.initialize();
        return this._tableMap.getTableNames();
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName={}) - start", (Object)tableName);
        this.initialize();
        if (!this._tableMap.containsTable(tableName)) {
            throw new NoSuchTableException(tableName);
        }
        ITableMetaData metaData = (ITableMetaData)this._tableMap.get(tableName);
        if (metaData != null) {
            return metaData;
        }
        metaData = new DatabaseTableMetaData(tableName, this._connection, true, super.isCaseSensitiveTableNames());
        this._tableMap.update(tableName, metaData);
        return metaData;
    }

    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName={}) - start", (Object)tableName);
        this.initialize();
        try {
            ITableMetaData metaData = this.getTableMetaData(tableName);
            DatabaseConfig config = this._connection.getConfig();
            IResultSetTableFactory factory = (IResultSetTableFactory)config.getProperty("http://www.dbunit.org/properties/resultSetTableFactory");
            return factory.createTable(metaData, this._connection);
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
    }

    private static class OracleRecycleBinTableFilter
    implements ITableFilterSimple {
        private final DatabaseConfig _config;

        public OracleRecycleBinTableFilter(DatabaseConfig config) {
            this._config = config;
        }

        public boolean accept(String tableName) throws DataSetException {
            return !this._config.getFeature("http://www.dbunit.org/features/skipOracleRecycleBinTables") || !tableName.startsWith("BIN$");
        }
    }
}

