/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.util.ArrayList;
import java.util.Collections;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryTableIterator;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.OrderedTableNameMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)QueryDataSet.class);
    private final IDatabaseConnection _connection;
    private final OrderedTableNameMap _tables;

    public QueryDataSet(IDatabaseConnection connection) {
        this(connection, connection.getConfig().getFeature("http://www.dbunit.org/features/caseSensitiveTableNames"));
    }

    public QueryDataSet(IDatabaseConnection connection, boolean caseSensitiveTableNames) {
        super(caseSensitiveTableNames);
        if (connection == null) {
            throw new NullPointerException("The parameter 'connection' must not be null");
        }
        this._connection = connection;
        this._tables = super.createTableNameMap();
    }

    public void addTable(String tableName, String query) throws AmbiguousTableNameException {
        logger.debug("addTable(tableName={}, query={}) - start", (Object)tableName, (Object)query);
        this._tables.add(tableName, new TableEntry(tableName, query));
    }

    public void addTable(String tableName) throws AmbiguousTableNameException {
        logger.debug("addTable(tableName={}) - start", (Object)tableName);
        this.addTable(tableName, null);
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        }
        ArrayList tableEntries = new ArrayList(this._tables.orderedValues());
        if (reversed) {
            Collections.reverse(tableEntries);
        }
        return new QueryTableIterator(tableEntries, this._connection);
    }

    public String[] getTableNames() throws DataSetException {
        logger.debug("getTableNames() - start");
        return this._tables.getTableNames();
    }

    static class TableEntry {
        private final String _tableName;
        private final String _query;

        public TableEntry(String tableName, String query) {
            this._tableName = tableName;
            this._query = query;
        }

        public String getTableName() {
            return this._tableName;
        }

        public String getQuery() {
            return this._query;
        }
    }
}

