/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.csv.CsvParserException;
import org.dbunit.dataset.csv.CsvParserImpl;
import org.dbunit.dataset.csv.CsvProducer;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvURLProducer
implements IDataSetProducer {
    private static final Logger logger = LoggerFactory.getLogger((Class)CsvURLProducer.class);
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private URL base;
    private String tableList;

    public CsvURLProducer(URL base, String tableList) {
        this.base = base;
        this.tableList = tableList;
    }

    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        logger.debug("setConsumer(consumer) - start");
        this._consumer = consumer;
    }

    public void produce() throws DataSetException {
        logger.debug("produce() - start");
        this._consumer.startDataSet();
        try {
            List tableSpecs = CsvProducer.getTables(this.base, this.tableList);
            Iterator tableIter = tableSpecs.iterator();
            while (tableIter.hasNext()) {
                String table = (String)tableIter.next();
                try {
                    this.produceFromURL(new URL(this.base, table + ".csv"));
                }
                catch (CsvParserException e) {
                    throw new DataSetException("error producing dataset for table '" + table + "'", e);
                }
            }
            this._consumer.endDataSet();
        }
        catch (IOException e) {
            throw new DataSetException("error getting list of tables", e);
        }
    }

    private void produceFromURL(URL url) throws DataSetException {
        logger.debug("produceFromURL(url=" + url + ") - start");
        try {
            CsvParserImpl parser = new CsvParserImpl();
            List readData = parser.parse(url);
            List readColumns = (List)readData.get(0);
            Column[] columns = new Column[readColumns.size()];
            for (int i = 0; i < readColumns.size(); ++i) {
                columns[i] = new Column((String)readColumns.get(i), DataType.UNKNOWN);
            }
            String tableName = url.getFile();
            tableName = tableName.substring(tableName.lastIndexOf("/") + 1, tableName.indexOf(".csv"));
            DefaultTableMetaData metaData = new DefaultTableMetaData(tableName, columns);
            this._consumer.startTable(metaData);
            for (int i = 1; i < readData.size(); ++i) {
                List rowList = (List)readData.get(i);
                Object[] row = rowList.toArray();
                for (int col = 0; col < row.length; ++col) {
                    if (!"null".equals(row[col])) continue;
                    row[col] = null;
                }
                this._consumer.row(row);
            }
            this._consumer.endTable();
        }
        catch (CsvParserException e) {
            throw new DataSetException("error parsing CSV for URL: '" + url + "'");
        }
        catch (IOException e) {
            throw new DataSetException("I/O error parsing CSV for URL: '" + url + "'");
        }
    }
}

