/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)StringDataType.class);

    public StringDataType(String name, int sqlType) {
        super(name, sqlType, String.class, false);
    }

    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Date || value instanceof Time || value instanceof Timestamp) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Number) {
            try {
                return value.toString();
            }
            catch (NumberFormatException e) {
                throw new TypeCastException(value, this, e);
            }
        }
        if (value instanceof byte[]) {
            return Base64.encodeBytes((byte[])value);
        }
        if (value instanceof Blob) {
            try {
                Blob blob = (Blob)value;
                byte[] blobValue = blob.getBytes(1L, (int)blob.length());
                return this.typeCast(blobValue);
            }
            catch (SQLException e) {
                throw new TypeCastException(value, this, e);
            }
        }
        if (value instanceof Clob) {
            try {
                Clob clobValue = (Clob)value;
                int length = (int)clobValue.length();
                if (length > 0) {
                    return clobValue.getSubString(1L, length);
                }
                return "";
            }
            catch (SQLException e) {
                throw new TypeCastException(value, this, e);
            }
        }
        throw new TypeCastException(value, this);
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        String value;
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        if ((value = resultSet.getString(column)) == null || resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, new Integer(column), statement});
        }
        statement.setString(column, StringDataType.asString(value));
    }
}

