/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty.spring;

import java.util.List;
import java.util.Map;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.jsse.spring.TLSServerParametersConfig;
import org.apache.cxf.configuration.security.TLSServerParametersType;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transport.http_jetty.spring.JAXBHelper;
import org.apache.cxf.transports.http_jetty.configuration.TLSServerParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersType;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JettyHTTPServerEngineBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    public void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        String portStr = element.getAttribute("port");
        int port = Integer.valueOf(portStr);
        bean.addPropertyValue("port", (Object)port);
        MutablePropertyValues engineFactoryProperties = ctx.getContainingBeanDefinition().getPropertyValues();
        PropertyValue busValue = engineFactoryProperties.getPropertyValue("bus");
        try {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Object param;
                Object parametersType;
                Node n = children.item(i);
                if (n.getNodeType() != 1) continue;
                String name = n.getLocalName();
                if ("tlsServerParameters".equals(name)) {
                    parametersType = JAXBHelper.parseElement((Element)n, bean, TLSServerParametersType.class);
                    param = new TLSServerParametersConfig(parametersType);
                    bean.addPropertyValue("tlsServerParameters", param);
                    continue;
                }
                if ("tlsServerParametersRef".equals(name)) {
                    TLSServerParametersIdentifiedType parameterTypeRef = JAXBHelper.parseElement((Element)n, bean, TLSServerParametersIdentifiedType.class);
                    param = this.getTlsServerParameters(engineFactoryProperties, parameterTypeRef.getId());
                    bean.addPropertyValue("tlsServerParameters", param);
                    continue;
                }
                if ("threadingParameters".equals(name)) {
                    parametersType = JAXBHelper.parseElement((Element)n, bean, ThreadingParametersType.class);
                    param = this.toThreadingParameters((ThreadingParametersType)parametersType);
                    bean.addPropertyValue("threadingParameters", param);
                    continue;
                }
                if ("threadingParametersRef".equals(name)) {
                    ThreadingParametersIdentifiedType parametersTypeRef = JAXBHelper.parseElement((Element)n, bean, ThreadingParametersIdentifiedType.class);
                    param = this.getThreadingParameters(engineFactoryProperties, parametersTypeRef.getId());
                    bean.addPropertyValue("threadingParameters", param);
                    continue;
                }
                if ("connector".equals(name)) {
                    List list = ctx.getDelegate().parseListElement((Element)n, (BeanDefinition)bean.getBeanDefinition());
                    bean.addPropertyValue("connector", list.get(0));
                    continue;
                }
                if ("handlers".equals(name)) {
                    List handlers = ctx.getDelegate().parseListElement((Element)n, (BeanDefinition)bean.getBeanDefinition());
                    bean.addPropertyValue("handlers", (Object)handlers);
                    continue;
                }
                if (!"sessionSupport".equals(name) && !"reuseAddress".equals(name)) continue;
                String text = n.getTextContent();
                bean.addPropertyValue(name, (Object)Boolean.valueOf(text));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process configuration.", e);
        }
        bean.addPropertyValue("bus", busValue.getValue());
        bean.setLazyInit(false);
    }

    private TLSServerParameters getTlsServerParameters(MutablePropertyValues engineFactoryProperties, String reference) {
        TLSServerParameters result = null;
        PropertyValue tlsParameterMapValue = engineFactoryProperties.getPropertyValue("tlsServerParametersMap");
        if (null == tlsParameterMapValue) {
            throw new RuntimeException("Could not find the tlsServerParametersMap from the JettyHTTPServerEngineFactory!");
        }
        Map tlsServerParametersMap = (Map)tlsParameterMapValue.getValue();
        result = (TLSServerParameters)tlsServerParametersMap.get(reference);
        if (result == null) {
            throw new RuntimeException("Could not find the tlsServerParametersMap reference [" + reference + "]'s mapping tlsParameter");
        }
        return result;
    }

    private ThreadingParameters getThreadingParameters(MutablePropertyValues engineFactoryProperties, String reference) {
        ThreadingParameters result = null;
        PropertyValue threadingParametersMapValue = engineFactoryProperties.getPropertyValue("threadingParametersMap");
        if (null == threadingParametersMapValue) {
            throw new RuntimeException("Could not find the threadingParametersMap from the JettyHTTPServerEngineFactory!");
        }
        Map threadingParametersMap = (Map)threadingParametersMapValue.getValue();
        result = (ThreadingParameters)threadingParametersMap.get(reference);
        if (result == null) {
            throw new RuntimeException("Could not find the threadingParametersMap reference [" + reference + "]'s mapping threadingParameters");
        }
        return result;
    }

    private ThreadingParameters toThreadingParameters(ThreadingParametersType paramtype) {
        ThreadingParameters params = new ThreadingParameters();
        params.setMaxThreads(paramtype.getMaxThreads());
        params.setMinThreads(paramtype.getMinThreads());
        return params;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected Class getBeanClass(Element arg0) {
        return JettyHTTPServerEngine.class;
    }
}

