/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.cms;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi.util.Base64;
import com.gpki.gpkiapi_jni;
import java.util.Calendar;
import java.util.Date;

public class SignedData {
    private byte[] outBuff = null;
    private byte[] msgBuff = null;
    private String errBuff = "";
    private String signTime = "";
    private String msgFilePathBuff = "";
    private String[] certArray = null;
    private long[] timeArray = null;
    private int cntBuff = 0;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public void setMessage(byte[] byArray) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The msg is null. You must input a value for it.");
        }
        this.msgBuff = byArray;
    }

    public void setMessage_File(String string) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The file path is null. You must input a value for it.");
        }
        this.msgFilePathBuff = string;
    }

    public void setSignTime(Date date) throws GpkiApiException {
        if (date == null) {
            throw new GpkiApiException("The time is null. You must input a value for it.");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.signTime = this.signTime + calendar.get(1);
        switch (calendar.get(2)) {
            case 0: {
                this.signTime = this.signTime + "01";
                break;
            }
            case 1: {
                this.signTime = this.signTime + "02";
                break;
            }
            case 2: {
                this.signTime = this.signTime + "03";
                break;
            }
            case 3: {
                this.signTime = this.signTime + "04";
                break;
            }
            case 4: {
                this.signTime = this.signTime + "05";
                break;
            }
            case 5: {
                this.signTime = this.signTime + "06";
                break;
            }
            case 6: {
                this.signTime = this.signTime + "07";
                break;
            }
            case 7: {
                this.signTime = this.signTime + "08";
                break;
            }
            case 8: {
                this.signTime = this.signTime + "09";
                break;
            }
            case 9: {
                this.signTime = this.signTime + "10";
                break;
            }
            case 10: {
                this.signTime = this.signTime + "11";
                break;
            }
            case 11: {
                this.signTime = this.signTime + "12";
            }
        }
        int n = calendar.get(5);
        if (n < 10) {
            this.signTime = this.signTime + "0";
        }
        this.signTime = this.signTime + n;
        int n2 = calendar.get(11);
        if (n2 < 10) {
            this.signTime = this.signTime + "0";
        }
        this.signTime = this.signTime + n2;
        int n3 = calendar.get(12);
        if (n3 < 10) {
            this.signTime = this.signTime + "0";
        }
        this.signTime = this.signTime + n3;
        int n4 = calendar.get(13);
        if (n4 < 10) {
            this.signTime = this.signTime + "0";
        }
        this.signTime = this.signTime + n4;
    }

    public byte[] generate(X509Certificate x509Certificate, PrivateKey privateKey) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The signCert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        if (this.gpkiapi.CMS_MakeSignedData(x509Certificate.getCert(), privateKey.getKey(), this.msgBuff, this.signTime) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public void generate_File(X509Certificate x509Certificate, PrivateKey privateKey, String string) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The signCert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        if (this._signData_File(x509Certificate.getCert(), privateKey.getKey(), this.msgFilePathBuff, this.signTime, string, false) > 0) {
            throw new GpkiApiException(this.errBuff);
        }
    }

    public void generate_noContent_File(X509Certificate x509Certificate, PrivateKey privateKey, String string) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The signCert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        if (this._signData_File(x509Certificate.getCert(), privateKey.getKey(), this.msgFilePathBuff, this.signTime, string, true) > 0) {
            throw new GpkiApiException(this.errBuff);
        }
    }

    public byte[] addSigner(byte[] byArray, X509Certificate x509Certificate, PrivateKey privateKey) throws GpkiApiException {
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The signedData is empty. You must input a value for it.");
        }
        if (x509Certificate == null) {
            throw new GpkiApiException("The signCert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        if (this.gpkiapi.CMS_MakeSignedDataWithAddSigner(x509Certificate.getCert(), privateKey.getKey(), byArray, this.signTime) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public void verify(byte[] byArray) throws GpkiApiException {
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The signedData is empty. You must input a value for it.");
        }
        if (this._verify(byArray) > 0) {
            throw new GpkiApiException(this.errBuff);
        }
    }

    public void verify_File(String string, String string2) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The signedDataFilePath is empty. You must input a value for it.");
        }
        if (string.length() == 0) {
            throw new GpkiApiException("The msgFilePath is empty. You must input a value for it.");
        }
        if (this._verify_File(string, string2, false) > 0) {
            throw new GpkiApiException(this.errBuff);
        }
    }

    public void verify_noContetn_File(String string, String string2) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The signedDataFilePath is empty. You must input a value for it.");
        }
        if (string.length() == 0) {
            throw new GpkiApiException("The msgFilePath is empty. You must input a value for it.");
        }
        if (this._verify_File(string, string2, true) > 0) {
            throw new GpkiApiException(this.errBuff);
        }
    }

    public byte[] getMessage() {
        return this.msgBuff;
    }

    public int getSignerCnt() {
        return this.cntBuff;
    }

    public X509Certificate getSignerCert(int n) throws GpkiApiException {
        if (n < 0) {
            throw new GpkiApiException("The index is negative.");
        }
        Base64 base64 = new Base64();
        byte[] byArray = base64.decode(this.certArray[n]);
        X509Certificate x509Certificate = new X509Certificate(byArray);
        return x509Certificate;
    }

    public Date getSigningTime(int n) throws GpkiApiException {
        if (n < 0) {
            throw new GpkiApiException("The index is negative.");
        }
        Date date = new Date(this.timeArray[n] * 1000L);
        return date;
    }

    protected void setSignerCert(int n, int n2, String string, long l) {
        if (n == 0) {
            this.certArray = new String[n2];
            this.timeArray = new long[n2];
        }
        this.certArray[n] = string;
        this.timeArray[n] = l;
    }

    private native int _verify(byte[] var1);

    private native int _signData_File(byte[] var1, byte[] var2, String var3, String var4, String var5, boolean var6);

    private native int _verify_File(String var1, String var2, boolean var3);
}

