/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.crypto;

import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;
import java.util.Hashtable;

public class Algorithm {
    private static final int ALG_RSA = 1;
    private static final int ALG_KCDSA = 3;
    private static final int ALG_ECC = 4;
    private static final int ALG_SEED = 16;
    private static final int ALG_SEED_CBC = 17;
    private static final int ALG_DES = 32;
    private static final int ALG_DES_CBC = 33;
    private static final int ALG_3DES = 48;
    private static final int ALG_3DES_CBC = 49;
    private static final int ALG_NEAT = 64;
    private static final int ALG_NEAT_CBC = 65;
    private static final int ALG_ARIA = 80;
    private static final int ALG_ARIA_CBC = 81;
    private static final int ALG_NES = 96;
    private static final int ALG_NES_CBC = 97;
    private static final int ALG_SHA1 = 256;
    private static final int ALG_HAS160 = 512;
    private static final int ALG_MD5 = 768;
    private static final int ALG_SHA256 = 1024;
    private static final int ALG_SHA1_HMAC = 4096;
    private static final int ALG_MD5_HMAC = 8192;
    private static Hashtable cipherAlg = new Hashtable();
    private static Hashtable keyPairAlg = new Hashtable();
    private static Hashtable secretKeyAlg = new Hashtable();
    private static Hashtable hashAlg = new Hashtable();
    private static Hashtable macAlg = new Hashtable();

    public static final int getCipherAlg(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algo is empty. You must input a value for it.");
        }
        Integer n = (Integer)cipherAlg.get(string.toUpperCase());
        if (n == null) {
            throw new GpkiApiException("Unknown ciher algorkthm (" + string + ").");
        }
        return n;
    }

    public static final int getSecretKeyAlg(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algo is empty. You must input a value for it.");
        }
        Integer n = (Integer)secretKeyAlg.get(string.toUpperCase());
        if (n == null) {
            throw new GpkiApiException("Unknown secret key algorkthm (" + string + ").");
        }
        return n;
    }

    public static final int getKeyPairAlg(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algo is empty. You must input a value for it.");
        }
        Integer n = (Integer)keyPairAlg.get(string.toUpperCase());
        if (n == null) {
            throw new GpkiApiException("Unknown key pair algorkthm (" + string + ").");
        }
        return n;
    }

    public static final int getMacAlg(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algo is empty. You must input a value for it.");
        }
        Integer n = (Integer)macAlg.get(string.toUpperCase());
        if (n == null) {
            throw new GpkiApiException("Unknown mac algorkthm (" + string + ").");
        }
        return n;
    }

    public static final int getHashAlg(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algo is empty. You must input a value for it.");
        }
        Integer n = (Integer)hashAlg.get(string.toUpperCase());
        if (n == null) {
            throw new GpkiApiException("Unknown hash algorkthm (" + string + ").");
        }
        return n;
    }

    public static final boolean isSame(String string, int n) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The keyAlgo is empty. You must input a value for it.");
        }
        Integer n2 = (Integer)secretKeyAlg.get(string.toUpperCase());
        if (n2 == null && (n2 = (Integer)keyPairAlg.get(string.toUpperCase())) == null) {
            return false;
        }
        int n3 = n2;
        if (n3 == n) {
            return true;
        }
        if (n3 == 16 && n == 17) {
            return true;
        }
        if (n3 == 48 && n == 49) {
            return true;
        }
        if (n3 == 64 && n == 65) {
            return true;
        }
        if (n3 == 80 && n == 81) {
            return true;
        }
        if (n3 == 96 && n == 97) {
            return true;
        }
        return n3 == 32 && n == 33;
    }

    public static final int code2id(int n) {
        switch (n) {
            case 16: 
            case 17: {
                return gpkiapi_jni.SYM_ALG_SEED_CBC;
            }
            case 32: 
            case 33: {
                return gpkiapi_jni.SYM_ALG_DES_CBC;
            }
            case 48: 
            case 49: {
                return gpkiapi_jni.SYM_ALG_3DES_CBC;
            }
            case 64: 
            case 65: {
                return gpkiapi_jni.SYM_ALG_NEAT_CBC;
            }
            case 80: 
            case 81: {
                return gpkiapi_jni.SYM_ALG_ARIA_CBC;
            }
            case 96: 
            case 97: {
                return gpkiapi_jni.SYM_ALG_NES_CBC;
            }
            case 256: {
                return gpkiapi_jni.HASH_ALG_SHA1;
            }
            case 512: {
                return gpkiapi_jni.HASH_ALG_HAS160;
            }
            case 768: {
                return gpkiapi_jni.HASH_ALG_MD5;
            }
            case 1024: {
                return gpkiapi_jni.HASH_ALG_SHA256;
            }
            case 4096: {
                return gpkiapi_jni.MAC_ALG_SHA1_HMAC;
            }
            case 8192: {
                return gpkiapi_jni.MAC_ALG_MD5_HMAC;
            }
        }
        return 0;
    }

    static {
        cipherAlg.put("RSA", new Integer(1));
        cipherAlg.put("RSA/V1.5", new Integer(1));
        cipherAlg.put("RSA/V2.0", new Integer(1));
        cipherAlg.put("SEED/CBC", new Integer(17));
        cipherAlg.put("DES/CBC", new Integer(33));
        cipherAlg.put("3DES/CBC", new Integer(49));
        cipherAlg.put("NEAT/CBC", new Integer(65));
        cipherAlg.put("ARIA/CBC", new Integer(81));
        cipherAlg.put("NES/CBC", new Integer(97));
        keyPairAlg.put("RSA", new Integer(1));
        secretKeyAlg.put("SEED", new Integer(16));
        secretKeyAlg.put("DES", new Integer(32));
        secretKeyAlg.put("3DES", new Integer(48));
        secretKeyAlg.put("NEAT", new Integer(64));
        secretKeyAlg.put("ARIA", new Integer(80));
        secretKeyAlg.put("NES", new Integer(96));
        hashAlg.put("SHA1", new Integer(256));
        hashAlg.put("HAS160", new Integer(512));
        hashAlg.put("MD5", new Integer(768));
        hashAlg.put("SHA256", new Integer(1024));
        macAlg.put("SHA1HMAC", new Integer(4096));
        macAlg.put("MD5HMAC", new Integer(8192));
    }
}

